/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.ImmutableMap;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportResult;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class SpeciesBatchUISupportImpl
extends SpeciesOrBenthosBatchUISupport {
    protected static final Map<String, String> CATCHES_UI_MODEL_PROPERTIES_MAPPING = ImmutableMap.builder().put((Object)"speciesTotalComputedWeight", (Object)"totalComputedWeight").put((Object)"speciesTotalSortedWeight", (Object)"totalSortedWeight").put((Object)"speciesTotalUnsortedComputedWeight", (Object)"totalUnsortedComputedWeight").put((Object)"speciesTotalSampleSortedComputedWeight", (Object)"totalSampleSortedComputedWeight").put((Object)"speciesTotalInertWeight", (Object)"totalInertWeight").put((Object)"speciesTotalLivingNotItemizedWeight", (Object)"totalLivingNotItemizedWeight").build();

    public SpeciesBatchUISupportImpl(TuttiUIContext context, EditCatchesUIModel catchesUIModel, WeightUnit weightUnit) {
        super(context, catchesUIModel, CATCHES_UI_MODEL_PROPERTIES_MAPPING, weightUnit);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(Integer batchId) {
        return this.getPersistenceService().getRootSpeciesBatch(batchId, true);
    }

    @Override
    public String getTitle() {
        return I18n.n((String)"tutti.label.tab.species", (Object[])new Object[0]);
    }

    @Override
    public boolean canPupitriImport() {
        return true;
    }

    @Override
    public boolean canPsionImport() {
        return true;
    }

    @Override
    public boolean canBigfinImport() {
        return true;
    }

    @Override
    public Float getTotalComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalComputedWeight();
    }

    @Override
    public void setTotalComputedWeight(Float totalComputedWeight) {
        this.catchesUIModel.setSpeciesTotalComputedWeight(totalComputedWeight);
    }

    @Override
    public ComputableData<Float> getTotalSortedComputedOrNotWeight() {
        return this.catchesUIModel.getSpeciesTotalSortedComputedOrNotWeight();
    }

    @Override
    public Float getTotalSortedWeight() {
        return this.catchesUIModel.getSpeciesTotalSortedWeight();
    }

    @Override
    public void setTotalSortedWeight(Float totalSortedWeight) {
        this.catchesUIModel.setSpeciesTotalSortedWeight(totalSortedWeight);
    }

    @Override
    public Float getTotalSortedComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalSortedComputedWeight();
    }

    @Override
    public void setTotalSortedComputedWeight(Float totalSortedComputedWeight) {
        this.catchesUIModel.setSpeciesTotalSortedComputedWeight(totalSortedComputedWeight);
    }

    @Override
    public Float getTotalUnsortedComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalUnsortedComputedWeight();
    }

    @Override
    public void setTotalUnsortedComputedWeight(Float totalUnsortedComputedWeight) {
        this.catchesUIModel.setSpeciesTotalUnsortedComputedWeight(totalUnsortedComputedWeight);
    }

    @Override
    public Float getTotalSampleSortedComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalSampleSortedComputedWeight();
    }

    @Override
    public void setTotalSampleSortedComputedWeight(Float totalSampleSortedComputedWeight) {
        this.catchesUIModel.setSpeciesTotalSampleSortedComputedWeight(totalSampleSortedComputedWeight);
    }

    @Override
    public ComputableData<Float> getTotalInertComputedOrNotWeight() {
        return this.catchesUIModel.getSpeciesTotalInertComputedOrNotWeight();
    }

    @Override
    public Float getTotalInertWeight() {
        return this.catchesUIModel.getSpeciesTotalInertWeight();
    }

    @Override
    public void setTotalInertWeight(Float totalInertWeight) {
        this.catchesUIModel.setSpeciesTotalInertWeight(totalInertWeight);
    }

    @Override
    public Float getTotalInertComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalInertComputedWeight();
    }

    @Override
    public void setTotalInertComputedWeight(Float totalInertComputedWeight) {
        this.catchesUIModel.setSpeciesTotalInertComputedWeight(totalInertComputedWeight);
    }

    @Override
    public ComputableData<Float> getTotalLivingNotItemizedComputedOrNotWeight() {
        return this.catchesUIModel.getSpeciesTotalLivingNotItemizedComputedOrNotWeight();
    }

    @Override
    public Float getTotalLivingNotItemizedWeight() {
        return this.catchesUIModel.getSpeciesTotalLivingNotItemizedWeight();
    }

    @Override
    public void setTotalLivingNotItemizedWeight(Float totalLivingNotItemizedWeight) {
        this.catchesUIModel.setSpeciesTotalLivingNotItemizedWeight(totalLivingNotItemizedWeight);
    }

    @Override
    public Float getTotalLivingNotItemizedComputedWeight() {
        return this.catchesUIModel.getSpeciesTotalLivingNotItemizedComputedWeight();
    }

    @Override
    public void setTotalLivingNotItemizedComputedWeight(Float totalLivingNotItemizedComputedWeight) {
        this.catchesUIModel.setSpeciesTotalLivingNotItemizedComputedWeight(totalLivingNotItemizedComputedWeight);
    }

    @Override
    public Integer getDistinctSortedSpeciesCount() {
        return this.catchesUIModel.getSpeciesDistinctSortedSpeciesCount();
    }

    @Override
    public void setDistinctSortedSpeciesCount(Integer distinctSortedSpeciesCount) {
        this.catchesUIModel.setSpeciesDistinctSortedSpeciesCount(distinctSortedSpeciesCount);
    }

    @Override
    public Integer getDistinctUnsortedSpeciesCount() {
        return this.catchesUIModel.getSpeciesDistinctUnsortedSpeciesCount();
    }

    @Override
    public void setDistinctUnsortedSpeciesCount(Integer distinctUnsortedSpeciesCount) {
        this.catchesUIModel.setSpeciesDistinctUnsortedSpeciesCount(distinctUnsortedSpeciesCount);
    }

    @Override
    public Map<String, Object> importMultiPost(File file, FishingOperation operation, boolean importFrequencies, boolean importIndivudalObservations) {
        return this.context.getMultiPostImportService().importSpecies(file, operation, importFrequencies, importIndivudalObservations);
    }

    @Override
    public MultiPostImportResult importMultiPost(File file, FishingOperation operation, SpeciesBatch speciesBatch, boolean importFrequencies, boolean importIndivudalObservations) {
        return this.context.getMultiPostImportService().importSpeciesBatch(file, operation, speciesBatch, importFrequencies, importIndivudalObservations);
    }

    @Override
    public void exportMultiPost(File file, FishingOperation operation, boolean importFrequencies, boolean importIndivudalObservations) {
        this.context.getMultiPostExportService().exportSpecies(file, operation, importFrequencies, importIndivudalObservations);
    }

    @Override
    public void exportMultiPost(File file, FishingOperation operation, SpeciesBatch speciesBatch, boolean importFrequencies, boolean importIndivudalObservations) {
        this.context.getMultiPostExportService().exportBatch(file, operation, speciesBatch, importFrequencies, importIndivudalObservations);
    }

    @Override
    public SpeciesBatch createBatch(SpeciesBatch speciesBatch, Integer parentBatchId) {
        return this.getPersistenceService().createSpeciesBatch(speciesBatch, parentBatchId, true);
    }

    @Override
    public SpeciesBatch saveBatch(SpeciesBatch speciesBatch) {
        return this.getPersistenceService().saveSpeciesBatch(speciesBatch);
    }

    @Override
    public List<SpeciesBatchFrequency> saveBatchFrequencies(Integer speciesBatchId, List<SpeciesBatchFrequency> frequency) {
        return this.getPersistenceService().saveSpeciesBatchFrequency(speciesBatchId, frequency);
    }

    @Override
    public List<Species> getReferentSpeciesWithSurveyCode(boolean restrictToProtocol) {
        return this.context.getDataContext().getReferentSpeciesWithSurveyCode(restrictToProtocol);
    }

    @Override
    public List<Species> getReferentOtherSpeciesWithSurveyCode(boolean restrictToProtocol) {
        return this.context.getDataContext().getReferentBenthosWithSurveyCode(restrictToProtocol);
    }

    @Override
    public List<SpeciesProtocol> getSpeciesFromProtocol() {
        return this.context.getDataContext().getProtocol().getSpecies();
    }

    @Override
    public void deleteSpeciesSubBatch(Integer speciesBatchId) {
        this.getPersistenceService().deleteSpeciesSubBatch(speciesBatchId);
    }

    @Override
    public void deleteSpeciesBatch(Integer speciesBatchId) {
        this.getPersistenceService().deleteSpeciesBatch(speciesBatchId);
    }
}

