/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.change.ChangeFactory;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.NamespaceDetails;
import liquibase.parser.NamespaceDetailsFactory;
import liquibase.parser.core.xml.LiquibaseEntityResolver;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.util.ISODateFormat;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.XMLUtil;
import liquibase.util.xml.DefaultXmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLChangeLogSerializer
implements ChangeLogSerializer {
    private Document currentChangeLogFileDOM;

    public XMLChangeLogSerializer() {
        try {
            this.currentChangeLogFileDOM = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected XMLChangeLogSerializer(Document currentChangeLogFileDOM) {
        this.currentChangeLogFileDOM = currentChangeLogFileDOM;
    }

    public void setCurrentChangeLogFileDOM(Document currentChangeLogFileDOM) {
        this.currentChangeLogFileDOM = currentChangeLogFileDOM;
    }

    @Override
    public String[] getValidFileExtensions() {
        return new String[]{"xml"};
    }

    public String serialize(DatabaseChangeLog databaseChangeLog) {
        return null;
    }

    @Override
    public String serialize(LiquibaseSerializable object, boolean pretty) {
        StringBuffer buffer = new StringBuffer();
        int indent = -1;
        if (pretty) {
            indent = 0;
        }
        this.nodeToStringBuffer(this.createNode(object), buffer, indent);
        return buffer.toString();
    }

    @Override
    public void write(List<ChangeSet> changeSets, OutputStream out) throws IOException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        documentBuilder.setEntityResolver(new LiquibaseEntityResolver(this));
        Document doc = documentBuilder.newDocument();
        Element changeLogElement = doc.createElementNS("http://www.liquibase.org/xml/ns/dbchangelog", "databaseChangeLog");
        changeLogElement.setAttribute("xmlns", "http://www.liquibase.org/xml/ns/dbchangelog");
        changeLogElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        HashMap<String, String> shortNameByNamespace = new HashMap<String, String>();
        HashMap<String, String> urlByNamespace = new HashMap<String, String>();
        String[] stringArray = ChangeFactory.getInstance().getAllChangeNamespaces();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            NamespaceDetails details = NamespaceDetailsFactory.getInstance().getNamespaceDetails(this, namespace);
            if (details != null) {
                shortNameByNamespace.put(namespace, details.getShortName(namespace));
                urlByNamespace.put(namespace, details.getSchemaUrl(namespace));
            }
            ++n2;
        }
        for (Map.Entry entry : shortNameByNamespace.entrySet()) {
            if (((String)entry.getValue()).equals("")) continue;
            changeLogElement.setAttribute("xmlns:" + (String)entry.getValue(), (String)entry.getKey());
        }
        String schemaLocationAttribute = "";
        for (Map.Entry entry : urlByNamespace.entrySet()) {
            if (((String)entry.getValue()).equals("")) continue;
            schemaLocationAttribute = String.valueOf(schemaLocationAttribute) + (String)entry.getKey() + " " + (String)entry.getValue() + " ";
        }
        changeLogElement.setAttribute("xsi:schemaLocation", schemaLocationAttribute.trim());
        doc.appendChild(changeLogElement);
        this.setCurrentChangeLogFileDOM(doc);
        for (ChangeSet changeSet : changeSets) {
            doc.getDocumentElement().appendChild(this.createNode(changeSet));
        }
        new DefaultXmlWriter().write(doc, out);
    }

    @Override
    public void append(ChangeSet changeSet, File changeLogFile) throws IOException {
        FileInputStream in = new FileInputStream(changeLogFile);
        String existingChangeLog = StreamUtil.getStreamContents(in);
        in.close();
        FileOutputStream out = new FileOutputStream(changeLogFile);
        try {
            if (!existingChangeLog.contains("</databaseChangeLog>")) {
                this.write(Arrays.asList(changeSet), out);
            } else {
                existingChangeLog = existingChangeLog.replaceFirst("</databaseChangeLog>", String.valueOf(this.serialize(changeSet, true)) + "\n</databaseChangeLog>");
                StreamUtil.copy(new ByteArrayInputStream(existingChangeLog.getBytes()), out);
            }
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public Element createNode(LiquibaseSerializable object) {
        String namespace = object.getSerializedObjectNamespace();
        String nodeName = object.getSerializedObjectName();
        NamespaceDetails details = NamespaceDetailsFactory.getInstance().getNamespaceDetails(this, namespace);
        if (details != null && !details.getShortName(namespace).equals("")) {
            nodeName = String.valueOf(details.getShortName(namespace)) + ":" + nodeName;
        }
        Element node = this.currentChangeLogFileDOM.createElementNS(namespace, nodeName);
        for (String field : object.getSerializableFields()) {
            this.setValueOnNode(node, field, object.getSerializableFieldValue(field), object.getSerializableFieldType(field));
        }
        return node;
    }

    private void setValueOnNode(Element node, String objectName, Object value, LiquibaseSerializable.SerializationType serializationType) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            for (Object child : (Collection)value) {
                this.setValueOnNode(node, objectName, child, serializationType);
            }
        } else if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Element mapNode = this.currentChangeLogFileDOM.createElementNS("http://www.liquibase.org/xml/ns/dbchangelog", objectName);
                this.setValueOnNode(mapNode, (String)entry.getKey(), entry.getValue(), serializationType);
            }
        } else if (value instanceof LiquibaseSerializable) {
            node.appendChild(this.createNode((LiquibaseSerializable)value));
        } else if (serializationType.equals((Object)LiquibaseSerializable.SerializationType.NESTED_OBJECT)) {
            String namespace = "http://www.liquibase.org/xml/ns/dbchangelog";
            node.appendChild(this.createNode(namespace, objectName, value.toString()));
        } else if (serializationType.equals((Object)LiquibaseSerializable.SerializationType.DIRECT_VALUE)) {
            node.setTextContent(value.toString());
        } else {
            node.setAttribute(objectName, value.toString());
        }
    }

    public Element createNode(String nodeNamespace, String nodeName, String nodeContent) {
        Element element = this.currentChangeLogFileDOM.createElementNS(nodeNamespace, nodeName);
        element.setTextContent(nodeContent);
        return element;
    }

    public Element createNode(ColumnConfig columnConfig) {
        ConstraintsConfig constraints;
        Element element = this.currentChangeLogFileDOM.createElementNS(columnConfig.getSerializedObjectNamespace(), "column");
        if (columnConfig.getName() != null) {
            element.setAttribute("name", columnConfig.getName());
        }
        if (columnConfig.getType() != null) {
            element.setAttribute("type", columnConfig.getType());
        }
        if (columnConfig.getDefaultValue() != null) {
            element.setAttribute("defaultValue", columnConfig.getDefaultValue());
        }
        if (columnConfig.getDefaultValueNumeric() != null) {
            element.setAttribute("defaultValueNumeric", columnConfig.getDefaultValueNumeric().toString());
        }
        if (columnConfig.getDefaultValueDate() != null) {
            element.setAttribute("defaultValueDate", new ISODateFormat().format(columnConfig.getDefaultValueDate()));
        }
        if (columnConfig.getDefaultValueBoolean() != null) {
            element.setAttribute("defaultValueBoolean", columnConfig.getDefaultValueBoolean().toString());
        }
        if (columnConfig.getDefaultValueComputed() != null) {
            element.setAttribute("defaultValueComputed", columnConfig.getDefaultValueComputed().toString());
        }
        if (columnConfig.getDefaultValueSequenceNext() != null) {
            element.setAttribute("defaultValueSequenceNext", columnConfig.getDefaultValueSequenceNext().toString());
        }
        if (columnConfig.getValue() != null) {
            element.setAttribute("value", columnConfig.getValue());
        }
        if (columnConfig.getValueNumeric() != null) {
            element.setAttribute("valueNumeric", columnConfig.getValueNumeric().toString());
        }
        if (columnConfig.getValueBoolean() != null) {
            element.setAttribute("valueBoolean", columnConfig.getValueBoolean().toString());
        }
        if (columnConfig.getValueDate() != null) {
            element.setAttribute("valueDate", new ISODateFormat().format(columnConfig.getValueDate()));
        }
        if (columnConfig.getValueComputed() != null) {
            element.setAttribute("valueComputed", columnConfig.getValueComputed().toString());
        }
        if (columnConfig.getValueSequenceNext() != null) {
            element.setAttribute("valueSequenceNext", columnConfig.getValueSequenceNext().toString());
        }
        if (columnConfig.getValueSequenceCurrent() != null) {
            element.setAttribute("valueSequenceNext", columnConfig.getValueSequenceCurrent().toString());
        }
        if (StringUtils.trimToNull(columnConfig.getRemarks()) != null) {
            element.setAttribute("remarks", columnConfig.getRemarks());
        }
        if (columnConfig.isAutoIncrement() != null && columnConfig.isAutoIncrement().booleanValue()) {
            element.setAttribute("autoIncrement", "true");
        }
        if ((constraints = columnConfig.getConstraints()) != null) {
            Element constraintsElement = this.currentChangeLogFileDOM.createElementNS(columnConfig.getSerializedObjectNamespace(), "constraints");
            if (constraints.getCheckConstraint() != null) {
                constraintsElement.setAttribute("checkConstraint", constraints.getCheckConstraint());
            }
            if (constraints.getForeignKeyName() != null) {
                constraintsElement.setAttribute("foreignKeyName", constraints.getForeignKeyName());
            }
            if (constraints.getReferences() != null) {
                constraintsElement.setAttribute("references", constraints.getReferences());
            }
            if (constraints.getReferencedTableName() != null) {
                constraintsElement.setAttribute("referencedTableName", constraints.getReferencedTableName());
            }
            if (constraints.getReferencedColumnNames() != null) {
                constraintsElement.setAttribute("referencedTableName", constraints.getReferencedColumnNames());
            }
            if (constraints.isDeferrable() != null) {
                constraintsElement.setAttribute("deferrable", constraints.isDeferrable().toString());
            }
            if (constraints.isDeleteCascade() != null) {
                constraintsElement.setAttribute("deleteCascade", constraints.isDeleteCascade().toString());
            }
            if (constraints.isInitiallyDeferred() != null) {
                constraintsElement.setAttribute("initiallyDeferred", constraints.isInitiallyDeferred().toString());
            }
            if (constraints.isNullable() != null) {
                constraintsElement.setAttribute("nullable", constraints.isNullable().toString());
            }
            if (constraints.isPrimaryKey() != null) {
                constraintsElement.setAttribute("primaryKey", constraints.isPrimaryKey().toString());
            }
            if (constraints.isUnique() != null) {
                constraintsElement.setAttribute("unique", constraints.isUnique().toString());
            }
            if (constraints.getUniqueConstraintName() != null) {
                constraintsElement.setAttribute("uniqueConstraintName", constraints.getUniqueConstraintName());
            }
            if (constraints.getPrimaryKeyName() != null) {
                constraintsElement.setAttribute("primaryKeyName", constraints.getPrimaryKeyName());
            }
            if (constraints.getPrimaryKeyTablespace() != null) {
                constraintsElement.setAttribute("primaryKeyTablespace", constraints.getPrimaryKeyTablespace());
            }
            element.appendChild(constraintsElement);
        }
        return element;
    }

    private void nodeToStringBuffer(Node node, StringBuffer buffer, int indent) {
        if (indent >= 0) {
            if (indent > 0) {
                buffer.append("\n");
            }
            buffer.append(StringUtils.repeat(" ", indent));
        }
        buffer.append("<").append(node.getNodeName());
        TreeMap<String, String> attributeMap = new TreeMap<String, String>();
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            attributeMap.put(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        boolean firstAttribute = true;
        for (Map.Entry entry : attributeMap.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            if (indent >= 0 && !firstAttribute && attributeMap.size() > 2) {
                buffer.append("\n").append(StringUtils.repeat(" ", indent)).append("        ");
            } else {
                buffer.append(" ");
            }
            buffer.append(entry.getKey()).append("=\"").append(value).append("\"");
            firstAttribute = false;
        }
        String textContent = StringUtils.trimToEmpty(XMLUtil.getTextContent(node));
        buffer.append(">").append(textContent);
        boolean sawChildren = false;
        NodeList childNodes = node.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node childNode = childNodes.item(i2);
            if (childNode instanceof Element) {
                int newIndent = indent;
                if (newIndent >= 0) {
                    newIndent += 4;
                }
                this.nodeToStringBuffer(childNode, buffer, newIndent);
                sawChildren = true;
            }
            ++i2;
        }
        if (indent >= 0 && sawChildren) {
            buffer.append("\n").append(StringUtils.repeat(" ", indent));
        }
        if (!sawChildren && textContent.equals("")) {
            buffer.replace(buffer.length() - 1, buffer.length(), "/>");
        } else {
            buffer.append("</").append(node.getNodeName()).append(">");
        }
    }
}

