/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential.consumer;

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.csv.GearModel;
import fr.ifremer.tutti.service.referential.csv.GearRow;
import java.nio.file.Path;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class CsvConsumerForTemporaryGear
extends CsvComsumer<GearRow, GearModel> {
    private static final Log log = LogFactory.getLog(CsvConsumerForTemporaryGear.class);

    public CsvConsumerForTemporaryGear(Path file, char separator, boolean failFast) {
        super(file, GearModel.forImport(separator), failFast);
    }

    public void checkRow(ImportRow<GearRow> row, PersistenceService persistenceService, DecoratorService decoratorService, ReferentialImportRequest<Gear, Integer> requestResult) {
        if (row.isValid()) {
            GearRow bean = (GearRow)row.getBean();
            Integer id = bean.getIdAsInt();
            boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
            if (id == null) {
                this.checkAdd(bean, requestResult);
            } else {
                Gear gear = requestResult.getExistingEntityById(id);
                if (gear == null) {
                    throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.notExistingId", (Object[])new Object[]{id}));
                }
                if (delete) {
                    this.checkDelete(bean, gear, persistenceService, decoratorService, requestResult);
                } else {
                    this.checkUpdate(bean, gear, requestResult);
                }
            }
        }
        this.reportError(row);
    }

    public void checkRowForGenericFormatImport(ImportRow<GearRow> row, ReferentialImportRequest<Gear, Integer> requestResult) {
        GearRow bean = (GearRow)row.getBean();
        String name = bean.getName();
        if (row.isValid()) {
            Integer id = bean.getIdAsInt();
            if (id == null) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.noId", (Object[])new Object[0]))));
            } else if (!Gears.isTemporaryId((Integer)id)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.idNotTemporary", (Object[])new Object[]{id}))));
            } else if (requestResult.isIdAlreadyAdded(id)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.id.alreaydAdded", (Object[])new Object[]{id}))));
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.noName", (Object[])new Object[0]))));
            } else if (requestResult.isNaturalIdAlreadyAdded(name)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.name.alreaydAdded", (Object[])new Object[]{name}))));
            }
        }
        this.reportError(row);
        if (row.isValid()) {
            Gear entity = bean.toEntity();
            boolean toAdd = requestResult.addExistingNaturalId(name);
            if (toAdd) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will add gear with name: " + name));
                }
                requestResult.addEntityToAdd(entity);
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will link gear with name: " + name));
                }
                requestResult.addEntityToLink(entity);
            }
        }
    }

    protected void checkAdd(GearRow bean, ReferentialImportRequest<Gear, Integer> requestResult) {
        String name = bean.getName();
        boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
        if (delete) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.cannotDeleteWithoutId", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.noName", (Object[])new Object[0]));
        }
        if (!requestResult.addExistingNaturalId(name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.existingName", (Object[])new Object[]{name}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will add gear with name: " + name));
        }
        requestResult.addEntityToAdd(bean.toEntity());
    }

    protected void checkDelete(GearRow bean, Gear gear, PersistenceService persistenceService, DecoratorService decoratorService, ReferentialImportRequest<Gear, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = bean.getName();
        if (persistenceService.isTemporaryGearUsed(id)) {
            String gearRef = id + " : " + decoratorService.getDecoratorByType(Gear.class).toString((Object)gear);
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.used", (Object[])new Object[]{gearRef}));
        }
        requestResult.addIdToDelete(id);
        requestResult.removeExistingNaturalId(name);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete gear with name: " + name));
        }
        requestResult.addEntityToAdd(bean.toEntity());
    }

    protected void checkUpdate(GearRow bean, Gear gear, ReferentialImportRequest<Gear, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = bean.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.noName", (Object[])new Object[]{id}));
        }
        if (!name.equals(gear.getName()) && !requestResult.addExistingNaturalId(name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.gear.error.existingName", (Object[])new Object[]{name}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will update gear with name: " + name));
        }
        requestResult.addEntityToUpdate(bean.toEntity());
    }
}

