/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.EntityParserFormatterSupport;
import java.util.List;
import java.util.Map;

public class PersonParserFormatter
extends EntityParserFormatterSupport<Person> {
    private final PersistenceService persistenceService;
    private final Map<String, String> idTranslationMap;

    public static PersonParserFormatter newFormatter() {
        return new PersonParserFormatter(false, null, null);
    }

    public static PersonParserFormatter newTechnicalFormatter() {
        return new PersonParserFormatter(true, null, null);
    }

    public static PersonParserFormatter newParser(PersistenceService persistenceService, Map<String, String> idTranslationMap) {
        return new PersonParserFormatter(true, persistenceService, idTranslationMap);
    }

    protected PersonParserFormatter(boolean technical, PersistenceService persistenceService, Map<String, String> idTranslationMap) {
        super("", technical, Person.class);
        this.persistenceService = persistenceService;
        this.idTranslationMap = idTranslationMap;
    }

    @Override
    protected List<Person> getEntities() {
        return this.persistenceService.getAllPerson();
    }

    @Override
    protected List<Person> getEntitiesWithObsoletes() {
        return this.persistenceService.getAllPersonWithObsoletes();
    }

    @Override
    protected String formatBusiness(Person person) {
        return (String)Persons.GET_FULL_NAME.apply((Object)person);
    }

    @Override
    protected Person parseNotBlankValue(String value) {
        if (this.idTranslationMap.containsKey(value)) {
            value = this.idTranslationMap.get(value);
        }
        return (Person)super.parseNotBlankValue(value);
    }
}

