/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.type;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Comparator;
import java.util.Objects;
import org.nuiton.i18n.I18n;

public enum WeightUnit implements Comparator<Float>
{
    G(I18n.n((String)"application.common.unit.g", (Object[])new Object[0]), I18n.n((String)"application.common.unit.short.g", (Object[])new Object[0]), 1, "\\d{0,8}(\\.\\d{0,1})?", 0.01f){

        @Override
        public Float fromEntity(Float weight) {
            return weight == null ? null : Float.valueOf(weight.floatValue() * 1000.0f);
        }

        @Override
        public Float toEntity(Float weight) {
            return weight == null ? null : Float.valueOf(weight.floatValue() / 1000.0f);
        }
    }
    ,
    KG(I18n.n((String)"application.common.unit.kg", (Object[])new Object[0]), I18n.n((String)"application.common.unit.short.kg", (Object[])new Object[0]), 4, "\\d{0,6}(\\.\\d{0,4})?", 1.0E-5f){

        @Override
        public Float fromEntity(Float weight) {
            return weight;
        }

        @Override
        public Float toEntity(Float weight) {
            return weight;
        }
    };

    private final String i18nShortKey;
    private final String i18nKey;
    private final int numberDigits;
    private final String numberEditorPattern;
    private final float rawPrecision;
    private final DecimalFormat decimalFormat;

    private WeightUnit(String i18nKey, String i18nShortKey, int numberDigits, String numberEditorPattern, float rawPrecision) {
        this.i18nKey = i18nKey;
        this.i18nShortKey = i18nShortKey;
        this.numberDigits = numberDigits;
        this.numberEditorPattern = numberEditorPattern;
        this.rawPrecision = rawPrecision;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        this.decimalFormat = new DecimalFormat();
        this.decimalFormat.setDecimalFormatSymbols(symbols);
        this.decimalFormat.setGroupingUsed(false);
        this.decimalFormat.setMinimumFractionDigits(1);
        this.decimalFormat.setMaximumFractionDigits(numberDigits);
    }

    @Override
    public int compare(Float v0, Float v1) {
        Objects.requireNonNull(v0, "can not compare null weights");
        Objects.requireNonNull(v1, "can not compare null weights");
        float delta = this.roundWithSign(v0).floatValue() - this.roundWithSign(v1).floatValue();
        int result = delta > this.rawPrecision ? 1 : (delta < -this.rawPrecision ? -1 : 0);
        return result;
    }

    public String getLabel() {
        return I18n.t((String)this.i18nKey, (Object[])new Object[0]);
    }

    public String getShortLabel() {
        return I18n.t((String)this.i18nShortKey, (Object[])new Object[0]);
    }

    public int getNumberDigits() {
        return this.numberDigits;
    }

    public String getNumberEditorPattern() {
        return this.numberEditorPattern;
    }

    public String renderWeight(Float weight) {
        String textValue = weight == null ? "" : this.decimalFormat.format(weight);
        return textValue;
    }

    public abstract Float fromEntity(Float var1);

    public abstract Float toEntity(Float var1);

    public Float round(Float weight) {
        Float result;
        if (weight == null) {
            result = null;
        } else {
            BigDecimal sumB = new BigDecimal(String.valueOf(weight)).setScale(this.numberDigits, 4).abs();
            result = Float.valueOf(sumB.floatValue());
        }
        return result;
    }

    public Float roundWithSign(Float weight) {
        Float result;
        if (weight == null) {
            result = null;
        } else {
            BigDecimal sumB = new BigDecimal(String.valueOf(weight)).setScale(this.numberDigits, 4);
            result = Float.valueOf(sumB.floatValue());
        }
        return result;
    }

    public String decorateLabel(String label) {
        return String.format("%s (%s)", label, this.getShortLabel());
    }

    public String renderFromEntityWithShortLabel(float o) {
        return this.round(this.fromEntity(Float.valueOf(o))) + this.getShortLabel();
    }

    public String decorateTip(String tip) {
        String unit = I18n.t((String)"application.common.unit", (Object[])new Object[0]);
        return String.format("%s (%s %s)", tip, unit, this.getLabel());
    }

    public boolean isNullOrZero(Float o) {
        return o == null || this.isZero(o.floatValue());
    }

    public boolean isNotNullNorZero(Float o) {
        return o != null && !this.isZero(o.floatValue());
    }

    public boolean isEquals(float o1, float o2) {
        return this.compare(Float.valueOf(o1), Float.valueOf(o2)) == 0;
    }

    public boolean isZero(float o) {
        return this.isEquals(o, 0.0f);
    }

    public boolean isNotEquals(float o1, float o2) {
        return this.compare(Float.valueOf(o1), Float.valueOf(o2)) != 0;
    }

    public boolean isSmallerThan(float o1, float o2) {
        return this.compare(Float.valueOf(o1), Float.valueOf(o2)) < 0;
    }

    public boolean isGreaterThan(float o1, float o2) {
        return this.compare(Float.valueOf(o1), Float.valueOf(o2)) > 0;
    }

    public boolean isGreaterThanZero(float o) {
        return this.isGreaterThan(o, 0.0f);
    }

    public boolean isSmallerThanZero(float o) {
        return this.isSmallerThan(o, 0.0f);
    }
}

