/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.service.sampling.IndividualObservationSamplingCacheRequest;
import fr.ifremer.tutti.service.sampling.SamplingCodeCache;
import fr.ifremer.tutti.service.sampling.SamplingCodePrefix;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SamplingCodeUICache
implements Closeable {
    private static final Log log = LogFactory.getLog(SamplingCodeUICache.class);
    private final SpeciesFrequencyUIModel uiModel;
    private final Integer cruiseId;
    private final SamplingCodeCache samplingCodeCache;
    private final Set<Integer> samplingCodesNotAvailable = new TreeSet<Integer>();
    private final Set<Integer> samplingCodesAvailable = new TreeSet<Integer>();
    private Integer speciesReferenceTaxonId;

    public SamplingCodeUICache(SamplingCodeCache samplingCodeCache, SpeciesFrequencyUIModel uiModel, Integer cruiseId) {
        this.samplingCodeCache = samplingCodeCache;
        this.uiModel = uiModel;
        this.cruiseId = cruiseId;
    }

    public void init(Species species, List<IndividualObservationBatchRowModel> individualObservations, boolean addToCache) {
        Objects.requireNonNull(species);
        Objects.requireNonNull(individualObservations);
        this.speciesReferenceTaxonId = species.getReferenceTaxonId();
        this.samplingCodesAvailable.clear();
        this.samplingCodesNotAvailable.clear();
        if (addToCache) {
            this.addIndividualObservations(individualObservations);
        } else {
            individualObservations.stream().filter(individualObservationRow -> individualObservationRow.getSamplingCode() != null).forEach(individualObservationRow -> this.addSamplingCodeNotAvailable(individualObservationRow.getSamplingCode()));
        }
    }

    @Override
    public void close() {
        this.samplingCodesNotAvailable.clear();
        this.samplingCodesAvailable.clear();
        this.speciesReferenceTaxonId = null;
    }

    public void addIndividualObservations(Collection<IndividualObservationBatchRowModel> individualObservations) {
        Objects.requireNonNull(individualObservations);
        individualObservations.stream().filter(IndividualObservationBatchRowModel::withSamplingCode).forEach(row -> {
            IndividualObservationSamplingCacheRequest samplingCacheRequest = this.uiModel.toSamplingCacheRequest((IndividualObservationBatchRowModel)row);
            this.addSampling(samplingCacheRequest);
        });
    }

    public void removeIndividualObservations(Collection<IndividualObservationBatchRowModel> individualObservations) {
        Objects.requireNonNull(individualObservations);
        individualObservations.stream().filter(IndividualObservationBatchRowModel::withSamplingCode).forEach(row -> {
            IndividualObservationSamplingCacheRequest samplingCacheRequest = this.uiModel.toSamplingCacheRequest((IndividualObservationBatchRowModel)row);
            this.removeSampling(samplingCacheRequest);
        });
    }

    public boolean canUseSamplingCode(Integer sampleCode) {
        if (this.isSamplingCodeNotAvailable(sampleCode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sampling code " + sampleCode + " is known as not available from cache. Can't use it."));
            }
            return false;
        }
        if (this.isSamplingCodeAvailable(sampleCode)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sampling code " + sampleCode + " is known as available from cache. Can use it."));
            }
            return true;
        }
        String samplingCodeSuffix = this.uiModel.getIndividualObservationModel().getSamplingCodePrefix().toSpeciesOnlySamplingCode(sampleCode.intValue());
        boolean samplingCodeAvailable = TuttiPersistenceServiceLocator.getPersistenceService().isSamplingCodeAvailable(this.cruiseId, this.speciesReferenceTaxonId, samplingCodeSuffix);
        if (log.isDebugEnabled()) {
            if (samplingCodeAvailable) {
                log.debug((Object)("Sampling code " + sampleCode + " is known as available from database. Can use it."));
            } else {
                log.debug((Object)("Sampling code " + sampleCode + " is known as not available from database. Can't use it."));
            }
        }
        return samplingCodeAvailable;
    }

    public int getNextSamplingCodeId() {
        int nextSamplingCodeId = this.samplingCodeCache.getNextSamplingCodeId(this.speciesReferenceTaxonId.intValue());
        if (log.isInfoEnabled()) {
            log.info((Object)("Generated sampling code: " + nextSamplingCodeId));
        }
        return nextSamplingCodeId;
    }

    public void addSampling(IndividualObservationSamplingCacheRequest samplingCacheRequest) {
        Objects.requireNonNull(samplingCacheRequest);
        String samplingCode = samplingCacheRequest.getSamplingCode();
        Objects.requireNonNull(samplingCode);
        this.samplingCodeCache.addSamplingCode(this.speciesReferenceTaxonId.intValue(), samplingCode);
        this.addSamplingCodeNotAvailable(samplingCode);
    }

    public void removeSampling(IndividualObservationSamplingCacheRequest samplingCacheRequest) {
        Objects.requireNonNull(samplingCacheRequest);
        String samplingCode = samplingCacheRequest.getSamplingCode();
        Objects.requireNonNull(samplingCode);
        this.samplingCodeCache.removeSamplingCode(this.speciesReferenceTaxonId.intValue(), samplingCode);
        this.addSamplingCodeAvailable(samplingCode);
    }

    private boolean isSamplingCodeNotAvailable(int samplingCode) {
        return this.samplingCodesNotAvailable.contains(samplingCode);
    }

    private boolean isSamplingCodeAvailable(int samplingCode) {
        return this.samplingCodesAvailable.contains(samplingCode);
    }

    private void addSamplingCodeAvailable(String samplingCode) {
        int samplingCodeNumber = SamplingCodePrefix.extractSamplingCodeIdFromSamplingCode((String)samplingCode);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Make samplingCode: %s (%d) available", samplingCode, samplingCodeNumber));
        }
        this.samplingCodesNotAvailable.remove(samplingCodeNumber);
        this.samplingCodesAvailable.add(samplingCodeNumber);
    }

    private void addSamplingCodeNotAvailable(String samplingCode) {
        int samplingCodeNumber = SamplingCodePrefix.extractSamplingCodeIdFromSamplingCode((String)samplingCode);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Make samplingCode: %s (%d) not available", samplingCode, samplingCodeNumber));
        }
        this.samplingCodesNotAvailable.add(samplingCodeNumber);
        this.samplingCodesAvailable.remove(samplingCodeNumber);
    }
}

