/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import fr.ifremer.tutti.type.WeightUnit;
import org.nuiton.i18n.I18n;

public class MarineLitterWeightComputingException
extends TuttiWeightComputingException {
    public static MarineLitterWeightComputingException forNoWeight(int index) {
        String errorMessage = I18n.t((String)"tutti.validator.warning.marineLitter.weight.required", (Object[])new Object[0]);
        return new MarineLitterWeightComputingException(errorMessage, "weight", index);
    }

    public static MarineLitterWeightComputingException forIncoherentTotal(WeightUnit weightUnit, Float marineLitterTotalWeight, Float marineLitterTotalComputedWeight) {
        String errorMessage = I18n.t((String)"tutti.service.operations.computeWeights.error.marineLitter.incoherentTotal", (Object[])new Object[]{weightUnit.renderFromEntityWithShortLabel(marineLitterTotalWeight.floatValue()), weightUnit.renderFromEntityWithShortLabel(marineLitterTotalComputedWeight.floatValue())});
        return new MarineLitterWeightComputingException(errorMessage);
    }

    private MarineLitterWeightComputingException(String message) {
        super(message);
    }

    private MarineLitterWeightComputingException(String message, String property, int index) {
        super(message, property, index);
    }
}

