/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.CalcifiedPiecesSamplingDefinition;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUI;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUIHandler;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolCpsAction
extends LongActionSupport<EditProtocolUIModel, CalcifiedPiecesSamplingEditorUI, CalcifiedPiecesSamplingEditorUIHandler> {
    private static final Log log = LogFactory.getLog(ImportProtocolCpsAction.class);
    private File file;
    private TuttiProtocol protocol;
    private Set<Species> notImportedSpecies;

    public ImportProtocolCpsAction(CalcifiedPiecesSamplingEditorUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(I18n.t((String)"tutti.editProtocol.title.choose.cpsImportFile", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.action.importProtocolCpsFile", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol cps file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        this.protocol = model.toEntity();
        ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        this.notImportedSpecies = service.importCalcifiedPiecesSamplings(this.file, this.protocol, model.getAllReferentSpeciesByTaxonId());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ArrayList<SpeciesProtocol> allSpeciesProtocol = new ArrayList<SpeciesProtocol>();
        if (!this.protocol.isSpeciesEmpty()) {
            allSpeciesProtocol.addAll(this.protocol.getSpecies());
        }
        if (!this.protocol.isBenthosEmpty()) {
            allSpeciesProtocol.addAll(this.protocol.getBenthos());
        }
        ArrayList<EditProtocolSpeciesRowModel> speciesRows = new ArrayList<EditProtocolSpeciesRowModel>();
        speciesRows.addAll(((EditProtocolUIModel)this.getModel()).getSpeciesRow());
        speciesRows.addAll(((EditProtocolUIModel)this.getModel()).getBenthosRow());
        Map rowsByRefTaxId = speciesRows.stream().collect(Collectors.toMap(EditProtocolSpeciesRowModel::getSpeciesReferenceTaxonId, Function.identity()));
        ArrayList<CalcifiedPiecesSamplingEditorRowModel> cpsRows = new ArrayList<CalcifiedPiecesSamplingEditorRowModel>();
        allSpeciesProtocol.forEach(speciesProtocol -> {
            Collection<CalcifiedPiecesSamplingDefinition> cpsDefs = speciesProtocol.getCalcifiedPiecesSamplingDefinition();
            if (cpsDefs != null) {
                cpsDefs.forEach(def -> {
                    CalcifiedPiecesSamplingEditorRowModel cpsRow = new CalcifiedPiecesSamplingEditorRowModel();
                    cpsRow.fromEntity(def);
                    cpsRow.setProtocolSpecies((EditProtocolSpeciesRowModel)rowsByRefTaxId.get(speciesProtocol.getSpeciesReferenceTaxonId()));
                    cpsRow.setValid(true);
                    cpsRows.add(cpsRow);
                });
            }
        });
        ((EditProtocolUIModel)this.getModel()).setCpsRows(cpsRows);
        if (log.isInfoEnabled()) {
            log.info((Object)("not imported cps : " + this.notImportedSpecies.size() + "\n" + this.notImportedSpecies));
        }
        this.sendMessage(I18n.t((String)"tutti.flash.info.cps.imported.in.protocol", (Object[])new Object[]{this.file}));
        if (!this.notImportedSpecies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Species sp : this.notImportedSpecies) {
                sb.append("<li>").append(this.decorate(sp, "fromProtocol")).append("</li>");
            }
            this.displayWarningMessage(I18n.t((String)"tutti.editProtocol.action.importProtocolCps.speciesNotImported.title", (Object[])new Object[0]), "<html><body>" + I18n.t((String)"tutti.editProtocol.action.importProtocolSpecies.speciesNotImported", (Object[])new Object[]{sb.toString()}) + "</body></html>");
        }
    }

    public void releaseAction() {
        this.file = null;
        this.protocol = null;
        this.notImportedSpecies = null;
        super.releaseAction();
    }
}

