/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.report.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.report.ReportGenerationRequest;
import fr.ifremer.tutti.service.report.ReportGenerationResult;
import fr.ifremer.tutti.service.report.ReportGenerationService;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIHandler;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import org.nuiton.i18n.I18n;

public class GenerateReportAction
extends LongActionSupport<ReportUIModel, ReportUI, ReportUIHandler> {
    protected ReportGenerationResult reportGenerationResult;

    public GenerateReportAction(ReportUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            ((ReportUIModel)this.getModel()).setReportGenerationResult(null);
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState((boolean)((ReportUIModel)this.getModel()).isValid());
        this.createProgressionModelIfRequired(1);
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments(I18n.t((String)"tutti.generateReport.action.computeNbSteps", (Object[])new Object[0]));
        ReportGenerationRequest reportGenerationRequest = (ReportGenerationRequest)((ReportUIModel)this.getModel()).toEntity();
        ReportGenerationService reportGenerationService = this.getContext().getReportGenerationService();
        int nbSteps = reportGenerationService.getNbSteps(reportGenerationRequest);
        progressionModel.adaptTotal(nbSteps);
        this.reportGenerationResult = reportGenerationService.generateReport(reportGenerationRequest, progressionModel);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((ReportUIModel)this.getModel()).setReportGenerationResult(this.reportGenerationResult);
        this.sendMessage(I18n.t((String)"tutti.report.generated", (Object[])new Object[0]));
    }

    protected void releaseAction() {
        super.releaseAction();
        this.reportGenerationResult = null;
    }
}

