/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.gson;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import fr.ifremer.adagio.core.dao.technical.gson.ParameterizedTypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class MultimapTypeAdapter
implements JsonSerializer<Multimap>,
JsonDeserializer<Multimap> {
    public JsonElement serialize(Multimap src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src.asMap(), this.createMapType(typeOfSrc));
    }

    public Multimap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        HashMultimap multimap = HashMultimap.create();
        Map map = (Map)context.deserialize(json, this.createMapType(typeOfT));
        for (Object key : map.keySet()) {
            Collection values = (Collection)map.get(key);
            multimap.putAll(key, (Iterable)values);
        }
        return multimap;
    }

    private Type createMapType(Type multimapType) {
        Preconditions.checkArgument((boolean)(multimapType instanceof ParameterizedType));
        ParameterizedType paramType = (ParameterizedType)multimapType;
        Type[] typeArguments = paramType.getActualTypeArguments();
        Preconditions.checkArgument((2 == typeArguments.length ? 1 : 0) != 0, (Object)"Type must contain exactly 2 type arguments.");
        ParameterizedTypeImpl valueType = new ParameterizedTypeImpl((Type)((Object)Collection.class), null, typeArguments[1]);
        ParameterizedTypeImpl mapType = new ParameterizedTypeImpl((Type)((Object)Map.class), null, typeArguments[0], valueType);
        return mapType;
    }
}

