/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.config;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.technical.AdagioEnumerationDef;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.util.RecursiveProperties;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.core.io.Resource;

public class AdagioEnumerationHelper {
    private static final Log log = LogFactory.getLog(AdagioEnumerationHelper.class);
    private static final String MODEL_PACKAGE_NAME = "fr.ifremer.adagio.core.dao";
    private static List<AdagioEnumerationDef<?>> cachedModelEnumsAsConfigOptions = null;

    public static List<AdagioEnumerationDef<?>> getAllModelEnumerations() {
        if (cachedModelEnumsAsConfigOptions != null) {
            return cachedModelEnumsAsConfigOptions;
        }
        Reflections reflections = Reflections.collect();
        if (reflections == null) {
            reflections = new Reflections(MODEL_PACKAGE_NAME, new Scanner[0]);
        }
        Set enumerationClasses = reflections.getSubTypesOf(AdagioEnumerationDef.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s enumeration classes detected in package [%s]", enumerationClasses.size(), MODEL_PACKAGE_NAME));
        }
        ArrayList options = Lists.newArrayList();
        for (Class enumClass : enumerationClasses) {
            Object[] enums = (AdagioEnumerationDef[])enumClass.getEnumConstants();
            if (ArrayUtils.isEmpty((Object[])enums)) {
                log.warn((Object)String.format("Enumeration class [%s] has no value. Skipped.", enumClass.getName()));
                continue;
            }
            Object[] objectArray = enums;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object aEnum;
                Object configOption = aEnum = objectArray[i];
                options.add(configOption);
            }
        }
        cachedModelEnumsAsConfigOptions = options;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s enumeration values detected in package [%s]", options.size(), MODEL_PACKAGE_NAME));
        }
        return cachedModelEnumsAsConfigOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload(ApplicationConfig applicationConfig, List<Resource> resources) {
        RecursiveProperties enumerationProperties = new RecursiveProperties();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Starting to load enumeration values...", new Object[0]));
        }
        for (Resource resource : resources) {
            InputStreamReader isr = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Load enumeration file: " + resource.getURI().toString()));
                }
                isr = new InputStreamReader(resource.getInputStream(), Charsets.UTF_8);
                enumerationProperties.load(isr);
            }
            catch (IOException e) {
                try {
                    log.warn((Object)String.format("Could not load enumeration file: %s. File skipped.", resource.getFilename()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(isr);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)isr);
                continue;
            }
            IOUtils.closeQuietly((Reader)isr);
        }
        for (Object key : enumerationProperties.keySet()) {
            String value = enumerationProperties.getProperty((String)key);
            applicationConfig.setDefaultOption("adagio.enumeration." + (String)key, value);
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)String.format(" %s%s (%s)", "adagio.enumeration.", (String)key, value));
        }
        List<AdagioEnumerationDef<?>> modelOptions = AdagioEnumerationHelper.getAllModelEnumerations();
        for (AdagioEnumerationDef<?> enumDef : modelOptions) {
            Class<?> clazz = enumDef.getType();
            String key = enumDef.getKey();
            String stringValue = applicationConfig.getOption(key);
            Object value = applicationConfig.getOption(clazz, key);
            if (value == null || enumDef.getValue().equals(value)) continue;
            if (!stringValue.equals(value.toString())) {
                log.warn((Object)String.format("Incompatible value '%s' for property '%s' (%s expected): Value skipped.", stringValue, key, enumDef.getType().getSimpleName()));
                continue;
            }
            Object oldValue = enumDef.getValue();
            try {
                enumDef.setValue(value);
            }
            catch (ClassCastException cce) {
                log.warn((Object)String.format("Could not set %s with value %s", key, value));
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)String.format(" %s (%s -> %s)", key, oldValue, value));
        }
    }
}

