/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.ComplexValueHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.ColorPropertyType;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class ColorHandle
extends ComplexValueHandle {
    private static final ColorPropertyType type = (ColorPropertyType)MetaDataDictionary.getInstance().getPropertyType(4);

    public ColorHandle(DesignElementHandle element, StructureContext context) {
        super(element, context);
        assert (context.getPropDefn().getType() instanceof ColorPropertyType);
    }

    public ColorHandle(DesignElementHandle element, MemberRef context) {
        super(element, context);
        assert (context.getPropDefn().getType() instanceof ColorPropertyType);
    }

    public ColorHandle(DesignElementHandle element, ElementPropertyDefn thePropDefn) {
        super(element, thePropDefn);
        assert (thePropDefn.getType() instanceof ColorPropertyType);
    }

    public int getRGB() {
        return type.toInteger(this.getModule(), this.getValue());
    }

    public void setRGB(int rgbValue) throws SemanticException {
        this.setValue(rgbValue);
    }

    public String getCssValue() {
        return type.toCSSCompatibleColor(this.getModule(), this.getValue());
    }

    public List getColors() {
        List retList = this.getCSSColors();
        List<Object> colors = this.getModule().getListProperty(this.getModule(), "colorPalette");
        if (colors == null) {
            return retList;
        }
        int i = 0;
        while (i < colors.size()) {
            CustomColor customColor = (CustomColor)colors.get(i);
            retList.add(customColor.getDisplayName(this.getModule()));
            ++i;
        }
        return retList;
    }

    public List getCSSColors() {
        ArrayList<String> retList = new ArrayList<String>();
        IChoice[] colors = type.getChoices().getChoices();
        int i = 0;
        while (i < colors.length) {
            retList.add(colors[i].getDisplayName());
            ++i;
        }
        return retList;
    }
}

