/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.util.Collection;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.nuiton.i18n.I18n;

public class AddBenthosProtocolAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    protected Species species;
    protected EditProtocolSpeciesRowModel newRow;

    public AddBenthosProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        this.species = null;
        EditProtocolUI ui = (EditProtocolUI)this.getUI();
        BeanFilterableComboBox<Species> benthosComboBox = ui.getBenthosComboBox();
        this.species = (Species)benthosComboBox.getSelectedItem();
        Preconditions.checkNotNull((Object)this.species, (Object)"Can't add a benthosProtocol with a null species");
        Preconditions.checkArgument((boolean)this.species.isReferenceTaxon(), (Object)"Can't add a benthosProtocol with a not referent species");
        Integer taxonId = this.species.getReferenceTaxonId();
        String taxonIdStr = String.valueOf(taxonId);
        Collection<Species> allSynonyms = ((EditProtocolUIModel)this.getModel()).getAllSynonyms(taxonIdStr);
        ((EditProtocolUIModel)this.getModel()).getAllSynonyms().removeAll(allSynonyms);
        this.newRow = ((EditProtocolUIHandler)this.handler).createNewProtocolSpeciesRow();
        this.newRow.setSpecies(this.species);
        ((EditProtocolUIModel)this.getModel()).getBenthosRow().add(this.newRow);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditProtocolUI)this.getUI()).getBenthosComboBox().removeItem((Object)this.species);
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().removeItem((Object)this.species);
        ((EditProtocolUI)this.getUI()).getCalcifiedPiecesSamplingEditorUI().getSpeciesComboBox().addItem((Object)this.species);
        EditProtocolSpeciesTableModel tableModel = ((EditProtocolUIHandler)this.getHandler()).getBenthosTableModel();
        tableModel.fireTableRowsInserted(this.newRow);
        int rowIndex = tableModel.getRowIndex(this.newRow);
        SwingUtil.setSelectionInterval((JTable)((EditProtocolUIHandler)this.handler).getBenthosTable(), (int)rowIndex);
        String speciesStr = this.decorate(this.species);
        this.sendMessage(I18n.t((String)"tutti.flash.info.benthos.add.to.protocol", (Object[])new Object[]{speciesStr}));
    }
}

