/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesSortableRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.util.Numbers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;

public class SpeciesBatchUIModel
extends AbstractTuttiBatchUIModel<SpeciesBatchRowModel, SpeciesBatchUIModel>
implements TabContentModel,
SpeciesSortableRowModel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPLIT_BATCH_ENABLED = "splitBatchEnabled";
    public static final String PROPERTY_CHANGE_SAMPLE_CATEGORY_ENABLED = "changeSampleCategoryEnabled";
    public static final String PROPERTY_ADD_SAMPLE_CATEGORY_ENABLED = "addSampleCategoryEnabled";
    public static final String PROPERTY_REMOVE_SUB_BATCH_ENABLED = "removeSubBatchEnabled";
    public static final String PROPERTY_RENAME_BATCH_ENABLED = "renameBatchEnabled";
    public static final String PROPERTY_REMOVE_BATCH_ENABLED = "removeBatchEnabled";
    public static final String PROPERTY_CREATE_MELAG_ENABLED = "createMelagEnabled";
    public static final String PROPERTY_EDIT_FREQUENCIES_ENABLED = "editFrequenciesEnabled";
    public static final String PROPERTY_TABLE_VIEW_MODE = "tableViewMode";
    public static final String PROPERTY_TABLE_VIEW_MODE_ALL = "tableViewModeAll";
    public static final String PROPERTY_TABLE_VIEW_MODE_LEAF = "tableViewModeLeaf";
    public static final String PROPERTY_TABLE_VIEW_MODE_ROOT = "tableViewModeRoot";
    public static final String PROPERTY_ROOT_NUMBER = "rootNumber";
    public static final String PROPERTY_LEAF_NUMBER = "leafNumber";
    protected boolean splitBatchEnabled;
    protected boolean changeSampleCategoryEnabled;
    protected boolean addSampleCategoryEnabled;
    protected boolean removeBatchEnabled;
    protected boolean removeSubBatchEnabled;
    protected boolean createMelagEnabled = true;
    protected boolean renameBatchEnabled;
    private boolean editFrequenciesEnabled;
    protected TableViewMode tableViewMode;
    protected int rootNumber;
    protected int leafNumber;
    protected SpeciesSortMode speciesSortMode;
    protected int speciesDecoratorContextIndex;
    protected final SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport;

    public SpeciesBatchUIModel(SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport) {
        super(speciesOrBenthosBatchUISupport, (String[])Iterables.toArray(speciesOrBenthosBatchUISupport.getCatchesUIModelPropertiesMapping().keySet(), String.class));
        this.speciesOrBenthosBatchUISupport = speciesOrBenthosBatchUISupport;
    }

    public SpeciesOrBenthosBatchUISupport getSpeciesOrBenthosBatchUISupport() {
        return this.speciesOrBenthosBatchUISupport;
    }

    public EditCatchesUIModel getCatchesUIModel() {
        return this.speciesOrBenthosBatchUISupport.getCatchesUIModel();
    }

    public WeightUnit getWeightUnit() {
        return this.speciesOrBenthosBatchUISupport.getWeightUnit();
    }

    public boolean canPupitriImport() {
        return this.speciesOrBenthosBatchUISupport.canPupitriImport();
    }

    public boolean canPsionImport() {
        return this.speciesOrBenthosBatchUISupport.canPsionImport();
    }

    public boolean canBigfinImport() {
        return this.speciesOrBenthosBatchUISupport.canBigfinImport();
    }

    public Float getTotalComputedWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalComputedWeight();
    }

    public void setTotalComputedWeight(Float totalComputedWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalComputedWeight(totalComputedWeight);
    }

    public ComputableData<Float> getTotalSortedComputedOrNotWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalSortedComputedOrNotWeight();
    }

    public Float getTotalSortedWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalSortedWeight();
    }

    public void setTotalSortedWeight(Float totalSortedWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalSortedWeight(totalSortedWeight);
    }

    public Float getTotalSortedComputedWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalSortedComputedWeight();
    }

    public void setTotalSortedComputedWeight(Float totalSortedComputedWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalSortedComputedWeight(totalSortedComputedWeight);
    }

    public Float getTotalUnsortedComputedWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalUnsortedComputedWeight();
    }

    public void setTotalUnsortedComputedWeight(Float totalUnsortedComputedWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalUnsortedComputedWeight(totalUnsortedComputedWeight);
    }

    public Float getTotalSampleSortedComputedWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalSampleSortedComputedWeight();
    }

    public void setTotalSampleSortedComputedWeight(Float totalSampleSortedComputedWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalSampleSortedComputedWeight(totalSampleSortedComputedWeight);
    }

    public ComputableData<Float> getTotalInertComputedOrNotWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalInertComputedOrNotWeight();
    }

    public Float getTotalInertWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalInertWeight();
    }

    public void setTotalInertWeight(Float totalInertWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalInertWeight(totalInertWeight);
    }

    public Float getTotalInertComputedWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalInertComputedWeight();
    }

    public void setTotalInertComputedWeight(Float totalInertComputedWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalInertComputedWeight(totalInertComputedWeight);
    }

    public ComputableData<Float> getTotalLivingNotItemizedComputedOrNotWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalLivingNotItemizedComputedOrNotWeight();
    }

    public Float getTotalLivingNotItemizedWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalLivingNotItemizedWeight();
    }

    public void setTotalLivingNotItemizedWeight(Float totalLivingNotItemizedWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalLivingNotItemizedWeight(totalLivingNotItemizedWeight);
    }

    public Float getTotalLivingNotItemizedComputedWeight() {
        return this.speciesOrBenthosBatchUISupport.getTotalLivingNotItemizedComputedWeight();
    }

    public void setTotalLivingNotItemizedComputedWeight(Float totalLivingNotItemizedComputedWeight) {
        this.speciesOrBenthosBatchUISupport.setTotalLivingNotItemizedComputedWeight(totalLivingNotItemizedComputedWeight);
    }

    public Integer getDistinctSortedSpeciesCount() {
        return this.speciesOrBenthosBatchUISupport.getDistinctSortedSpeciesCount();
    }

    public void setDistinctSortedSpeciesCount(Integer distinctSortedSpeciesCount) {
        this.speciesOrBenthosBatchUISupport.setDistinctSortedSpeciesCount(distinctSortedSpeciesCount);
    }

    public Integer getDistinctUnsortedSpeciesCount() {
        return this.speciesOrBenthosBatchUISupport.getDistinctUnsortedSpeciesCount();
    }

    public void setDistinctUnsortedSpeciesCount(Integer distinctUnsortedSpeciesCount) {
        this.speciesOrBenthosBatchUISupport.setDistinctUnsortedSpeciesCount(distinctUnsortedSpeciesCount);
    }

    public void incDistinctSortedSpeciesCount() {
        Integer speciesCount = this.getDistinctSortedSpeciesCount();
        if (speciesCount == null) {
            speciesCount = 0;
        }
        this.setDistinctSortedSpeciesCount(speciesCount + 1);
    }

    public void decDistinctSortedSpeciesCount() {
        Integer speciesCount = this.getDistinctSortedSpeciesCount();
        if (speciesCount != null) {
            this.setDistinctSortedSpeciesCount(speciesCount - 1);
        }
    }

    public void incDistinctUnsortedSpeciesCount() {
        Integer speciesCount = this.getDistinctUnsortedSpeciesCount();
        if (speciesCount == null) {
            speciesCount = 0;
        }
        this.setDistinctUnsortedSpeciesCount(speciesCount + 1);
    }

    public void decDistinctUnsortedSpeciesCount() {
        Integer speciesCount = this.getDistinctUnsortedSpeciesCount();
        if (speciesCount != null) {
            this.setDistinctUnsortedSpeciesCount(speciesCount - 1);
        }
    }

    public TableViewMode getTableViewMode() {
        return this.tableViewMode;
    }

    public void setTableViewMode(TableViewMode tableViewMode) {
        TableViewMode oldValue = this.getTableViewMode();
        this.tableViewMode = tableViewMode;
        this.firePropertyChange(PROPERTY_TABLE_VIEW_MODE, (Object)oldValue, (Object)tableViewMode);
        this.firePropertyChange(PROPERTY_TABLE_VIEW_MODE_ALL, null, this.isTableViewModeAll());
        this.firePropertyChange(PROPERTY_TABLE_VIEW_MODE_LEAF, null, this.isTableViewModeLeaf());
        this.firePropertyChange(PROPERTY_TABLE_VIEW_MODE_ROOT, null, this.isTableViewModeRoot());
    }

    public boolean isTableViewModeAll() {
        return TableViewMode.ALL.equals((Object)this.tableViewMode);
    }

    public boolean isTableViewModeLeaf() {
        return TableViewMode.LEAF.equals((Object)this.tableViewMode);
    }

    public boolean isTableViewModeRoot() {
        return TableViewMode.ROOT.equals((Object)this.tableViewMode);
    }

    public Multimap<CaracteristicQualitativeValue, Species> getSpeciesUsed() {
        return this.catchesUIModel.getSpeciesUsed();
    }

    public int getRootNumber() {
        return this.rootNumber;
    }

    public void setRootNumber(int rootNumber) {
        Integer oldValue = this.getRootNumber();
        this.rootNumber = rootNumber;
        this.firePropertyChange(PROPERTY_ROOT_NUMBER, oldValue, rootNumber);
    }

    public int getLeafNumber() {
        return this.leafNumber;
    }

    public void setLeafNumber(int leafNumber) {
        Integer oldValue = this.getLeafNumber();
        this.leafNumber = leafNumber;
        this.firePropertyChange(PROPERTY_LEAF_NUMBER, oldValue, leafNumber);
    }

    public boolean isSplitBatchEnabled() {
        return this.splitBatchEnabled;
    }

    public void setSplitBatchEnabled(boolean splitBatchEnabled) {
        this.splitBatchEnabled = splitBatchEnabled;
        this.firePropertyChange(PROPERTY_SPLIT_BATCH_ENABLED, null, splitBatchEnabled);
    }

    public boolean isChangeSampleCategoryEnabled() {
        return this.changeSampleCategoryEnabled;
    }

    public void setChangeSampleCategoryEnabled(boolean changeSampleCategoryEnabled) {
        this.changeSampleCategoryEnabled = changeSampleCategoryEnabled;
        this.firePropertyChange(PROPERTY_CHANGE_SAMPLE_CATEGORY_ENABLED, null, changeSampleCategoryEnabled);
    }

    public boolean isAddSampleCategoryEnabled() {
        return this.addSampleCategoryEnabled;
    }

    public void setAddSampleCategoryEnabled(boolean addSampleCategoryEnabled) {
        this.addSampleCategoryEnabled = addSampleCategoryEnabled;
        this.firePropertyChange(PROPERTY_ADD_SAMPLE_CATEGORY_ENABLED, null, addSampleCategoryEnabled);
    }

    public boolean isRemoveBatchEnabled() {
        return this.removeBatchEnabled;
    }

    public void setRemoveBatchEnabled(boolean removeBatchEnabled) {
        this.removeBatchEnabled = removeBatchEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_BATCH_ENABLED, null, removeBatchEnabled);
    }

    public boolean isRemoveSubBatchEnabled() {
        return this.removeSubBatchEnabled;
    }

    public void setRemoveSubBatchEnabled(boolean removeSubBatchEnabled) {
        this.removeSubBatchEnabled = removeSubBatchEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_SUB_BATCH_ENABLED, null, removeSubBatchEnabled);
    }

    public boolean isRenameBatchEnabled() {
        return this.renameBatchEnabled;
    }

    public void setRenameBatchEnabled(boolean renameBatchEnabled) {
        this.renameBatchEnabled = renameBatchEnabled;
        this.firePropertyChange(PROPERTY_RENAME_BATCH_ENABLED, null, renameBatchEnabled);
    }

    public boolean isCreateMelagEnabled() {
        return this.createMelagEnabled;
    }

    public void setCreateMelagEnabled(boolean createMelagEnabled) {
        this.createMelagEnabled = createMelagEnabled;
        this.firePropertyChange(PROPERTY_CREATE_MELAG_ENABLED, null, createMelagEnabled);
    }

    public boolean isEditFrequenciesEnabled() {
        return this.editFrequenciesEnabled;
    }

    public void setEditFrequenciesEnabled(boolean editFrequenciesEnabled) {
        this.editFrequenciesEnabled = editFrequenciesEnabled;
        this.firePropertyChange(PROPERTY_EDIT_FREQUENCIES_ENABLED, null, editFrequenciesEnabled);
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.getRows()) && this.getTotalSortedWeight() == null && this.getTotalInertWeight() == null && this.getTotalLivingNotItemizedWeight() == null;
    }

    public String getTitle() {
        return this.speciesOrBenthosBatchUISupport.getTitle();
    }

    public String getIcon() {
        return null;
    }

    public boolean isCloseable() {
        return false;
    }

    public List<SpeciesBatchRowModel> getLeafs(Species species) {
        ArrayList result = Lists.newArrayList();
        for (SpeciesBatchRowModel rowModel : this.getRows()) {
            if (!rowModel.isBatchRoot()) continue;
            this.getLeafs(species, rowModel, result);
        }
        return result;
    }

    public void getLeafs(Species species, SpeciesBatchRowModel rowModel, List<SpeciesBatchRowModel> used) {
        if (rowModel.isBatchLeaf()) {
            if (species.equals(rowModel.getSpecies())) {
                used.add(rowModel);
            }
        } else {
            for (SpeciesBatchRowModel child : rowModel.getChildBatch()) {
                this.getLeafs(species, child, used);
            }
        }
    }

    public Map<Species, Integer> getSpeciesCount() {
        HashMap result = Maps.newHashMap();
        for (SpeciesBatchRowModel row : this.getRows()) {
            if (!row.isBatchLeaf()) continue;
            Species species = row.getSpecies();
            Integer count = Numbers.getValueOrComputedValue((Number)result.get(species), 0);
            List<SpeciesFrequencyRowModel> frequencies = row.getFrequency();
            if (CollectionUtils.isEmpty(frequencies)) {
                Integer number = row.getNumber();
                if (number != null) {
                    count = count + number;
                }
            } else {
                for (SpeciesFrequencyRowModel frequency : frequencies) {
                    Integer number = frequency.getNumber();
                    if (number == null) continue;
                    count = count + number;
                }
            }
            result.put(species, count);
        }
        return result;
    }

    @Override
    public SpeciesSortMode getSpeciesSortMode() {
        return this.speciesSortMode;
    }

    @Override
    public void setSpeciesSortMode(SpeciesSortMode speciesSortMode) {
        SpeciesSortMode oldValue = this.getSpeciesSortMode();
        this.speciesSortMode = speciesSortMode;
        this.firePropertyChange("speciesSortMode", (Object)oldValue, (Object)speciesSortMode);
        this.firePropertyChange("speciesSortModeNone", null, this.isSpeciesSortModeNone());
        this.firePropertyChange("speciesSortModeAsc", null, this.isSpeciesSortModeAsc());
        this.firePropertyChange("speciesSortModeDesc", null, this.isSpeciesSortModeDesc());
    }

    @Override
    public boolean isSpeciesSortModeNone() {
        return SpeciesSortMode.NONE.equals((Object)this.speciesSortMode);
    }

    @Override
    public boolean isSpeciesSortModeAsc() {
        return SpeciesSortMode.ASC.equals((Object)this.speciesSortMode);
    }

    @Override
    public boolean isSpeciesSortModeDesc() {
        return SpeciesSortMode.DESC.equals((Object)this.speciesSortMode);
    }

    @Override
    public int getSpeciesDecoratorContextIndex() {
        return this.speciesDecoratorContextIndex;
    }

    @Override
    public void setSpeciesDecoratorContextIndex(int speciesDecoratorContextIndex) {
        int oldValue = this.getSpeciesDecoratorContextIndex();
        this.speciesDecoratorContextIndex = speciesDecoratorContextIndex;
        this.firePropertyChange("speciesDecoratorContextIndex", oldValue, speciesDecoratorContextIndex);
    }
}

