/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.zones;

import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.ZoneEditorUI;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.StrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.SubStrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.ZoneNode;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZoneEditorUIHandler
extends AbstractTuttiUIHandler<EditProtocolUIModel, ZoneEditorUI> {
    private static final Log log = LogFactory.getLog(ZoneEditorUIHandler.class);

    public void afterInit(ZoneEditorUI zoneEditorUI) {
        this.initUI(zoneEditorUI);
        JTree availableStratasTree = ((ZoneEditorUI)this.ui).getAvailableStratasTree();
        SwingUtil.addExpandOnClickListener((JTree)availableStratasTree);
        JTree zonesTree = ((ZoneEditorUI)this.ui).getZonesTree();
        SwingUtil.addExpandOnClickListener((JTree)zonesTree);
        zonesTree.addTreeSelectionListener(event -> {
            TreePath[] selectedPaths = zonesTree.getSelectionPaths();
            boolean allStrataNode = true;
            if (selectedPaths != null) {
                if (selectedPaths.length == 1) {
                    boolean zoneSelected = event.getPath().getLastPathComponent() instanceof ZoneNode;
                    ((ZoneEditorUI)this.getUI()).getDeleteZoneMenuItem().setEnabled(zoneSelected);
                    ((ZoneEditorUI)this.getUI()).getRenameZoneMenuItem().setEnabled(zoneSelected);
                }
                for (TreePath selectedPath : selectedPaths) {
                    Object lastPathComponent = selectedPath.getLastPathComponent();
                    if (lastPathComponent instanceof StrataNode || lastPathComponent instanceof SubStrataNode) continue;
                    allStrataNode = false;
                    break;
                }
            }
            ((ZoneEditorUI)this.getUI()).getRemoveButton().setEnabled(selectedPaths != null && allStrataNode);
        });
        TreeSelectionListener enableAddStrataListener = evt -> {
            boolean addButtonEnabled = zonesTree.getSelectionCount() == 1 && zonesTree.getSelectionPath().getLastPathComponent() instanceof ZoneNode && availableStratasTree.getSelectionCount() >= 1;
            ((ZoneEditorUI)this.getUI()).getAddButton().setEnabled(addButtonEnabled);
        };
        zonesTree.addTreeSelectionListener(enableAddStrataListener);
        availableStratasTree.addTreeSelectionListener(enableAddStrataListener);
    }

    public SwingValidator<EditProtocolUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return ((ZoneEditorUI)this.ui).getZonesTree();
    }

    public void onCloseUI() {
    }

    public void onKeyPressedOnZones(KeyEvent e) {
        if (e.getKeyCode() == 10 && ((ZoneEditorUI)this.getUI()).getRemoveButton().isEnabled()) {
            this.getContext().getActionEngine().runAction((AbstractButton)((ZoneEditorUI)this.getUI()).getRemoveButton());
        }
    }

    public void onKeyPressedOnAvailableStratas(KeyEvent e) {
        if (e.getKeyCode() == 10 && ((ZoneEditorUI)this.getUI()).getAddButton().isEnabled()) {
            this.getContext().getActionEngine().runAction((AbstractButton)((ZoneEditorUI)this.getUI()).getAddButton());
        }
    }

    public void onMouseClickedPressedOnZones(MouseEvent e, JPopupMenu popup) {
        if (SwingUtilities.isRightMouseButton(e)) {
            Point p = e.getPoint();
            JTree source = (JTree)e.getSource();
            int rowIndex = source.getRowForLocation(p.x, p.y);
            if (log.isDebugEnabled()) {
                log.debug((Object)("At point [" + p + "] found Row " + rowIndex));
            }
            source.setSelectionRow(rowIndex);
            popup.show(source, e.getX(), e.getY());
        } else if (e.getClickCount() == 2 && ((ZoneEditorUI)this.getUI()).getRemoveButton().isEnabled()) {
            this.getContext().getActionEngine().runAction((AbstractButton)((ZoneEditorUI)this.getUI()).getRemoveButton());
        }
    }

    public void onMouseClickedOnAvailableStratas(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && ((ZoneEditorUI)this.getUI()).getAddButton().isEnabled()) {
            this.getContext().getActionEngine().runAction((AbstractButton)((ZoneEditorUI)this.getUI()).getAddButton());
        }
    }
}

