/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.AverageWeightsHistogramModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiNumberTickUnitSource;
import fr.ifremer.tutti.util.Units;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.nuiton.i18n.I18n;

public class AverageWeightsHistogramHandler
implements Closeable {
    private static final Log log = LogFactory.getLog(AverageWeightsHistogramHandler.class);
    private final AverageWeightsHistogramModel model;
    private final JFreeChart chart;
    private final JFrame popup;

    public AverageWeightsHistogramHandler(SpeciesFrequencyUI ui) {
        SpeciesFrequencyUIHandler uiHandler = ui.getHandler();
        SpeciesFrequencyUIModel uiModel = ui.getModel();
        this.model = uiModel.getAverageWeightsHistogramModel();
        this.chart = ChartFactory.createXYLineChart(null, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (String)this.model.getFrequencyWeightUnit().decorateLabel(I18n.t((String)"tutti.editSpeciesFrequencies.averageWeight.label", (Object[])new Object[0])), (XYDataset)this.model.getDataset());
        this.chart.clearSubtitles();
        ValueAxis rangeAxis = this.chart.getXYPlot().getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setStandardTickUnits((TickUnitSource)new NumberTickUnitSource());
        rangeAxis.setMinorTickMarksVisible(true);
        ValueAxis domainAxis = this.chart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRange(true);
        domainAxis.setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(true));
        domainAxis.setMinorTickMarksVisible(true);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
        plotRenderer.setSeriesPaint(0, (Paint)uiHandler.getConfig().getColorComputedWeights());
        plotRenderer.setBaseShapesVisible(true);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setDomainZoomable(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setPopupMenu(null);
        this.popup = new JFrame();
        this.popup.getContentPane().add((Component)chartPanel);
        this.popup.pack();
        uiModel.addPropertyChangeListener("step", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Float step1 = (Float)evt.getNewValue();
                AverageWeightsHistogramHandler.this.model.setStep(step1);
            }
        });
        uiModel.addPropertyChangeListener("lengthStepCaracteristicUnit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String unit = (String)evt.getNewValue();
                if (unit == null) {
                    unit = I18n.t((String)"tutti.editSpeciesFrequencies.unkownStepUnit", (Object[])new Object[0]);
                }
                String lengthStepLabelWithUnit = Units.getLabelWithUnit((String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (String)unit);
                AverageWeightsHistogramHandler.this.model.setLengthStepLabelWithUnit(lengthStepLabelWithUnit);
            }
        });
        this.model.addPropertyChangeListener("title", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String title = (String)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Average weights graph title changed to: " + title));
                }
                AverageWeightsHistogramHandler.this.popup.setTitle(title);
            }
        });
        this.model.addPropertyChangeListener("lengthStepLabelWithUnit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String lengthStepLabelWithUnit = (String)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Average weights graph lengthStepLabelWithUnit changed to: " + lengthStepLabelWithUnit));
                }
                AverageWeightsHistogramHandler.this.chart.getXYPlot().getDomainAxis().setLabel(lengthStepLabelWithUnit);
            }
        });
        this.model.addPropertyChangeListener("step", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Float step = (Float)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Average weights graph step changed to: " + step));
                }
                AverageWeightsHistogramHandler.this.chart.getXYPlot().getDomainAxis().setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(step.floatValue() == 1.0f));
                AverageWeightsHistogramHandler.this.model.getDataset().setIntervalWidth((double)step.floatValue());
            }
        });
        ui.getGraphAverageWeightButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AverageWeightsHistogramHandler.this.popup.setVisible(true);
            }
        });
    }

    @Override
    public void close() {
        this.popup.dispose();
    }
}

