/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.metadata.ArgumentInfo;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ClassInfo;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MemberInfo;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MethodInfo;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.metadata.validators.IValueValidator;

public class MetaDataBuilder {
    protected MetaDataDictionary dictionary = MetaDataDictionary.getInstance();

    public Choice createChoice() {
        return new Choice();
    }

    public ChoiceSet createChoiceSet() {
        return new ChoiceSet();
    }

    public void addChoiceSet(ChoiceSet choiceSet) throws MetaDataException {
        this.dictionary.addChoiceSet(choiceSet);
    }

    public ElementDefn createElementDefn() {
        return new ElementDefn();
    }

    public void addElementDefn(ElementDefn defn) throws MetaDataException {
        this.dictionary.addElementDefn(defn);
    }

    public SystemPropertyDefn createPropertyDefn() {
        return new SystemPropertyDefn();
    }

    public void addPropertyDefn(ElementDefn elementDefn, PropertyDefn propDefn) throws MetaDataException {
        elementDefn.addProperty(propDefn);
    }

    public ClassInfo createClassInfo() {
        return new ClassInfo();
    }

    public void addClassInfo(ClassInfo classInfo) throws MetaDataException {
        this.dictionary.addClass(classInfo);
    }

    public ArgumentInfo createArgumentInfo() {
        return new ArgumentInfo();
    }

    public MethodInfo createMethodInfo(boolean isConstructor) {
        return new MethodInfo(isConstructor);
    }

    public void addMethodInfo(ClassInfo classInfo, MethodInfo methodInfo) throws MetaDataException {
        if (methodInfo.isConstructor()) {
            if (classInfo.getConstructor() == null) {
                classInfo.setConstructor(methodInfo);
            }
        } else if (classInfo.findMethod(methodInfo.getName()) == null) {
            classInfo.addMethod(methodInfo);
        }
    }

    public MemberInfo createMemberInfo() {
        return new MemberInfo();
    }

    public void addMemberInfo(ClassInfo classInfo, MemberInfo memberInfo) throws MetaDataException {
        classInfo.addMemberDefn(memberInfo);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public void addValueValidator(IValueValidator validator) throws MetaDataException {
        this.dictionary.addValueValidator(validator);
    }
}

