/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util;

import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.data.sample.SampleDao;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.SampleEntity;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Component;

@Component(value="samplePersistenceHelper")
public class SamplePersistenceHelper
extends AbstractPersistenceService {
    private static final Log log = LogFactory.getLog(SamplePersistenceHelper.class);
    @Resource(name="caracteristicPersistenceService")
    private CaracteristicPersistenceService caracteristicService;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;
    @Resource(name="sampleDao")
    protected SampleDao sampleDao;

    public Sample create(Sample sample) {
        this.synchronizationStatusHelper.setDirty(sample);
        return this.sampleDao.create(sample);
    }

    public void update(Sample sample) {
        this.synchronizationStatusHelper.setDirty(sample);
        this.sampleDao.update(sample);
    }

    public Sample load(Integer id) {
        Sample sample = this.sampleDao.load(id);
        if (sample == null) {
            throw new DataRetrievalFailureException("Could not retrieve sample id=" + id);
        }
        return sample;
    }

    public void deleteSample(Integer sampleId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delete sample: " + sampleId));
        }
        Sample sample = this.load(sampleId);
        this.synchronizationStatusHelper.setDirty(sample);
        sample.getSampleMeasurements().clear();
        this.sampleDao.remove(sample);
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.SAMPLE, sampleId);
    }

    public void setSampleMeasurements(Sample target, CaracteristicMap caracteristics) {
        HashSet notChangedSampleMeasurements = Sets.newHashSet();
        if (target.getSampleMeasurements() != null) {
            notChangedSampleMeasurements.addAll(target.getSampleMeasurements());
        }
        for (Caracteristic caracteristic : caracteristics.keySet()) {
            SampleMeasurement vum = this.setSampleMeasurement(target, caracteristic, (Serializable)caracteristics.get(caracteristic));
            notChangedSampleMeasurements.remove(vum);
        }
        if (target.getSampleMeasurements() != null && notChangedSampleMeasurements.size() > 0) {
            target.getSampleMeasurements().removeAll(notChangedSampleMeasurements);
        }
    }

    public <S extends SampleEntity> void loadSampleMeasurements(S sample) {
        String lengthClassId;
        Integer sampleId = sample.getIdAsInt();
        Iterator<Object[]> list = this.queryList("sampleMeasurements", "sampleId", IntegerType.INSTANCE, sampleId);
        CaracteristicMap caracteristicMap = sample.getCaracteristics();
        while (list.hasNext()) {
            Object[] source = list.next();
            Integer pmfmId = (Integer)source[0];
            Caracteristic caracteristic = this.caracteristicService.getCaracteristic(pmfmId);
            Serializable value = this.getMeasurementValue(caracteristic, source);
            caracteristicMap.put(caracteristic, value);
        }
        Float weight = caracteristicMap.removeFloatValue(this.caracteristicService.getCaracteristic(PmfmId.WEIGHT_MEASURED.getValue()));
        if (weight != null) {
            sample.setWeight(weight);
        }
        if ((lengthClassId = caracteristicMap.removeStringValue(this.caracteristicService.getCaracteristic(PmfmId.ID_PMFM.getValue()))) != null) {
            Caracteristic lengthStepCaracteristic = this.caracteristicService.getCaracteristic(Integer.valueOf(lengthClassId));
            sample.setLengthStepCaracteristic(lengthStepCaracteristic);
            Float length = caracteristicMap.removeFloatValue(lengthStepCaracteristic);
            sample.setSize(length);
        }
    }

    public <S extends SampleEntity> Serializable getSampleMeasurementValue(Integer sampleId, Caracteristic caracteristic) {
        Object[] source = this.queryUnique("sampleMeasurement", "sampleId", IntegerType.INSTANCE, sampleId, "pmfmId", IntegerType.INSTANCE, caracteristic.getIdAsInt());
        Serializable value = null;
        if (source != null) {
            value = this.getMeasurementValue(caracteristic, source);
        }
        return value;
    }

    public <S extends SampleEntity> CaracteristicMap extractCommonSampleCaracteristics(S sample) {
        Caracteristic caracteristic;
        CaracteristicMap caracteristics = CaracteristicMap.copy(sample.getCaracteristics());
        if (sample.getWeight() != null) {
            caracteristic = this.caracteristicService.getWeightMeasuredCaracteristic();
            caracteristics.put(caracteristic, sample.getWeight());
        }
        if (sample.getLengthStepCaracteristic() != null) {
            caracteristic = this.caracteristicService.getCaracteristic(PmfmId.ID_PMFM.getValue());
            caracteristics.put(caracteristic, (Serializable)((Object)sample.getLengthStepCaracteristic().getId()));
            caracteristics.put(sample.getLengthStepCaracteristic(), sample.getSize());
        }
        return caracteristics;
    }

    protected SampleMeasurement setSampleMeasurement(Sample sample, Caracteristic caracteristic, Serializable value) {
        Integer pmfmId = caracteristic.getIdAsInt();
        SampleMeasurement result = null;
        if (sample.getSampleMeasurements() != null) {
            for (SampleMeasurement vum : sample.getSampleMeasurements()) {
                if (!pmfmId.equals(vum.getPmfm().getId())) continue;
                result = vum;
                break;
            }
        }
        if (result == null) {
            result = SampleMeasurement.Factory.newInstance();
            result.setSample(sample);
            if (sample.getSampleMeasurements() == null) {
                sample.setSampleMeasurements((Collection)Sets.newHashSet((Object[])new SampleMeasurement[]{result}));
            } else {
                sample.getSampleMeasurements().add(result);
            }
            result.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            result.setDepartment(sample.getRecorderDepartment());
            result.setPmfm((Pmfm)this.load(PmfmImpl.class, pmfmId));
        }
        this.measurementPersistenceHelper.setMeasurement((Measurement)result, caracteristic, value);
        return result;
    }

    protected Serializable getMeasurementValue(Caracteristic caracteristic, Object[] source) {
        Object value;
        int colIndex = 1;
        Float numericalValue = (Float)source[colIndex++];
        String alphanumericalValue = (String)source[colIndex++];
        Integer qualitativeValueId = (Integer)source[colIndex];
        switch (caracteristic.getCaracteristicType()) {
            case NUMBER: {
                value = numericalValue;
                break;
            }
            case QUALITATIVE: {
                value = CaracteristicQualitativeValues.getQualitativeValue(caracteristic, qualitativeValueId);
                break;
            }
            case TEXT: {
                value = alphanumericalValue;
                break;
            }
            default: {
                throw new IllegalStateException("Can't deal with caracteristicType: " + (Object)((Object)caracteristic.getCaracteristicType()));
            }
        }
        return value;
    }
}

