/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.OperationFieldMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolOperationFieldsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditProtocolUIModel
extends AbstractTuttiBeanUIModel<TuttiProtocol, EditProtocolUIModel>
implements TuttiProtocol {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CARACTERISTIC_MAPPING_ROWS = "caracteristicMappingRows";
    public static final String PROPERTY_OPERATION_FIELD_MAPPING_ROWS = "operationFieldMappingRows";
    public static final String PROPERTY_SPECIES_ROW = "speciesRow";
    public static final String PROPERTY_BENTHOS_ROW = "benthosRow";
    public static final String PROPERTY_REMOVE_SPECIES_ENABLED = "removeSpeciesEnabled";
    public static final String PROPERTY_REMOVE_BENTHOS_ENABLED = "removeBenthosEnabled";
    public static final String PROPERTY_REMOVE_CARACTERISTIC_MAPPING_ENABLED = "removeCaracteristicMappingEnabled";
    public static final String PROPERTY_MOVE_UP_CARACTERISTIC_MAPPING_ENABLED = "moveUpCaracteristicMappingEnabled";
    public static final String PROPERTY_MOVE_DOWN_CARACTERISTIC_MAPPING_ENABLED = "moveDownCaracteristicMappingEnabled";
    public static final String PROPERTY_IMPORTED = "imported";
    public static final String PROPERTY_CLONED = "cloned";
    public static final String PROPERTY_CLEANED = "cleaned";
    protected final TuttiProtocol editObject = TuttiProtocols.newTuttiProtocol();
    protected boolean imported;
    protected boolean cloned;
    protected boolean cleaned;
    protected boolean removeSpeciesEnabled;
    protected boolean removeBenthosEnabled;
    protected boolean removeCaracteristicMappingEnabled;
    protected boolean moveUpCaracteristicMappingEnabled;
    protected boolean moveDownCaracteristicMappingEnabled;
    protected List<Species> allSpecies;
    protected List<Species> allSynonyms;
    protected Multimap<String, Species> allSpeciesByTaxonId;
    protected Map<String, Species> allReferentSpeciesByTaxonId;
    protected List<Caracteristic> caracteristics;
    protected Map<String, Caracteristic> allCaracteristic;
    protected Map<Caracteristic, EditProtocolCaracteristicsRowModel> caracteristicMappingRows = new HashMap<Caracteristic, EditProtocolCaracteristicsRowModel>();
    protected List<EditProtocolOperationFieldsRowModel> operationFieldMappingRows = new ArrayList<EditProtocolOperationFieldsRowModel>();
    protected Map<String, MutableInt> numberOfRowsByColumn = new HashMap<String, MutableInt>();
    protected List<EditProtocolSpeciesRowModel> speciesRow;
    protected List<EditProtocolSpeciesRowModel> benthosRow;
    protected static Binder<EditProtocolUIModel, TuttiProtocol> toBeanBinder = BinderFactory.newBinder(EditProtocolUIModel.class, TuttiProtocol.class);
    protected static Binder<TuttiProtocol, EditProtocolUIModel> fromBeanBinder = BinderFactory.newBinder(TuttiProtocol.class, EditProtocolUIModel.class);

    public EditProtocolUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    @Override
    protected TuttiProtocol newEntity() {
        return TuttiProtocols.newTuttiProtocol();
    }

    public void setLengthClassesPmfm(List<Caracteristic> lengthClassesPmfm) {
        ArrayList ids = Lists.newArrayList(TuttiEntities.collecIds(lengthClassesPmfm));
        this.setLengthClassesPmfmId(ids);
    }

    public void setIndividualObservationPmfm(List<Caracteristic> individualObservationPmfm) {
        List<String> ids = TuttiEntities.collecIds(individualObservationPmfm);
        this.setIndividualObservationPmfmId(ids);
    }

    public Collection<EditProtocolCaracteristicsRowModel> getCaracteristicMappingRows() {
        return this.caracteristicMappingRows.values();
    }

    public void addCaracteristicMappingRow(EditProtocolCaracteristicsRowModel newRow) {
        this.caracteristicMappingRows.put(newRow.getPsfm(), newRow);
        this.firePropertyChange(PROPERTY_CARACTERISTIC_MAPPING_ROWS, null, this.getCaracteristicMappingRows());
    }

    public void removeCaracteristicMappingRows(Collection<EditProtocolCaracteristicsRowModel> rowsToRemove) {
        for (EditProtocolCaracteristicsRowModel row : rowsToRemove) {
            this.caracteristicMappingRows.remove(row.getPsfm());
        }
        this.firePropertyChange(PROPERTY_CARACTERISTIC_MAPPING_ROWS, null, this.getCaracteristicMappingRows());
    }

    public void setCaracteristicMappingRows(List<EditProtocolCaracteristicsRowModel> caracteristicMappingRows) {
        this.caracteristicMappingRows = new HashMap<Caracteristic, EditProtocolCaracteristicsRowModel>((Map<Caracteristic, EditProtocolCaracteristicsRowModel>)Maps.uniqueIndex(caracteristicMappingRows, (Function)new Function<EditProtocolCaracteristicsRowModel, Caracteristic>(){

            public Caracteristic apply(EditProtocolCaracteristicsRowModel editProtocolCaracteristicsRowModel) {
                return editProtocolCaracteristicsRowModel.getPsfm();
            }
        }));
        this.firePropertyChange(PROPERTY_CARACTERISTIC_MAPPING_ROWS, null, caracteristicMappingRows);
    }

    public boolean isCaracteristicUsedInMapping(Caracteristic caracteristic) {
        return this.caracteristicMappingRows.containsKey(caracteristic);
    }

    public Collection<Caracteristic> getUsedCaracteristics() {
        return this.caracteristicMappingRows.keySet();
    }

    public List<EditProtocolOperationFieldsRowModel> getOperationFieldMappingRows() {
        return this.operationFieldMappingRows;
    }

    public void setOperationFieldMappingRows(List<EditProtocolOperationFieldsRowModel> operationFieldMappingRows) {
        List<EditProtocolOperationFieldsRowModel> oldValue = this.getOperationFieldMappingRows();
        this.operationFieldMappingRows = operationFieldMappingRows;
        this.firePropertyChange(PROPERTY_OPERATION_FIELD_MAPPING_ROWS, oldValue, operationFieldMappingRows);
    }

    public List<EditProtocolSpeciesRowModel> getSpeciesRow() {
        return this.speciesRow;
    }

    public void setSpeciesRow(List<EditProtocolSpeciesRowModel> speciesRow) {
        List<EditProtocolSpeciesRowModel> oldValue = this.getSpeciesRow();
        this.speciesRow = speciesRow;
        this.firePropertyChange(PROPERTY_SPECIES_ROW, oldValue, speciesRow);
    }

    public List<EditProtocolSpeciesRowModel> getBenthosRow() {
        return this.benthosRow;
    }

    public void setBenthosRow(List<EditProtocolSpeciesRowModel> benthosRow) {
        List<EditProtocolSpeciesRowModel> oldValue = this.getBenthosRow();
        this.benthosRow = benthosRow;
        this.firePropertyChange(PROPERTY_BENTHOS_ROW, oldValue, benthosRow);
    }

    public boolean isRemoveSpeciesEnabled() {
        return this.removeSpeciesEnabled;
    }

    public void setRemoveSpeciesEnabled(boolean removeSpeciesEnabled) {
        this.removeSpeciesEnabled = removeSpeciesEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_SPECIES_ENABLED, null, removeSpeciesEnabled);
    }

    public boolean isRemoveBenthosEnabled() {
        return this.removeBenthosEnabled;
    }

    public void setRemoveBenthosEnabled(boolean removeBenthosEnabled) {
        this.removeBenthosEnabled = removeBenthosEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_BENTHOS_ENABLED, null, removeBenthosEnabled);
    }

    public boolean isRemoveCaracteristicMappingEnabled() {
        return this.removeCaracteristicMappingEnabled;
    }

    public void setRemoveCaracteristicMappingEnabled(boolean removeCaracteristicMappingEnabled) {
        this.removeCaracteristicMappingEnabled = removeCaracteristicMappingEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_CARACTERISTIC_MAPPING_ENABLED, null, removeCaracteristicMappingEnabled);
    }

    public boolean isMoveUpCaracteristicMappingEnabled() {
        return this.moveUpCaracteristicMappingEnabled;
    }

    public void setMoveUpCaracteristicMappingEnabled(boolean moveUpCaracteristicMappingEnabled) {
        this.moveUpCaracteristicMappingEnabled = moveUpCaracteristicMappingEnabled;
        this.firePropertyChange(PROPERTY_MOVE_UP_CARACTERISTIC_MAPPING_ENABLED, null, moveUpCaracteristicMappingEnabled);
    }

    public boolean isMoveDownCaracteristicMappingEnabled() {
        return this.moveDownCaracteristicMappingEnabled;
    }

    public void setMoveDownCaracteristicMappingEnabled(boolean moveDownCaracteristicMappingEnabled) {
        this.moveDownCaracteristicMappingEnabled = moveDownCaracteristicMappingEnabled;
        this.firePropertyChange(PROPERTY_MOVE_DOWN_CARACTERISTIC_MAPPING_ENABLED, null, moveDownCaracteristicMappingEnabled);
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        Boolean oldValue = this.isImported();
        this.imported = imported;
        this.firePropertyChange(PROPERTY_IMPORTED, oldValue, imported);
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public void setCloned(boolean cloned) {
        Boolean oldValue = this.isCloned();
        this.cloned = cloned;
        this.firePropertyChange(PROPERTY_CLONED, oldValue, cloned);
    }

    public boolean isCleaned() {
        return this.cleaned;
    }

    public void setCleaned(boolean cleaned) {
        Boolean oldValue = this.isCleaned();
        this.cleaned = cleaned;
        this.firePropertyChange(PROPERTY_CLEANED, oldValue, cleaned);
    }

    public List<Species> getAllSpecies() {
        return this.allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        this.allSpecies = allSpecies;
        if (this.allReferentSpeciesByTaxonId != null && allSpecies != null) {
            this.allSynonyms = Lists.newArrayList(allSpecies);
            this.allSynonyms.removeAll(this.allReferentSpeciesByTaxonId.values());
        }
    }

    public Multimap<String, Species> getAllSpeciesByTaxonId() {
        return this.allSpeciesByTaxonId;
    }

    public Collection<Species> getAllSynonyms(String taxonId) {
        return this.allSpeciesByTaxonId.get((Object)taxonId);
    }

    public void setAllSpeciesByTaxonId(Multimap<String, Species> allSpeciesByTaxonId) {
        this.allSpeciesByTaxonId = allSpeciesByTaxonId;
    }

    public List<Species> getAllSynonyms() {
        return this.allSynonyms;
    }

    public Map<String, Species> getAllReferentSpeciesByTaxonId() {
        return this.allReferentSpeciesByTaxonId;
    }

    public void setAllReferentSpeciesByTaxonId(Map<String, Species> allReferentSpeciesByTaxonId) {
        this.allReferentSpeciesByTaxonId = allReferentSpeciesByTaxonId;
        if (allReferentSpeciesByTaxonId != null && this.allSpecies != null) {
            this.allSynonyms = Lists.newArrayList(this.allSpecies);
            for (Species species : allReferentSpeciesByTaxonId.values()) {
                this.allSynonyms.remove(species);
            }
        }
    }

    public List<Caracteristic> getCaracteristics() {
        return this.caracteristics;
    }

    public void setCaracteristics(List<Caracteristic> caracteristics) {
        this.caracteristics = caracteristics;
    }

    public Map<String, Caracteristic> getAllCaracteristic() {
        return this.allCaracteristic;
    }

    public void setAllCaracteristic(Map<String, Caracteristic> allCaracteristic) {
        this.allCaracteristic = allCaracteristic;
    }

    @Override
    public String getName() {
        return this.editObject.getName();
    }

    @Override
    public void setName(String name) {
        String oldValue = this.getName();
        this.editObject.setName(name);
        this.firePropertyChange("name", oldValue, name);
    }

    @Override
    public String getComment() {
        return this.editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public List<String> getLengthClassesPmfmId() {
        return this.editObject.getLengthClassesPmfmId();
    }

    @Override
    public void setLengthClassesPmfmId(List<String> lengthClassesPmfmId) {
        this.editObject.setLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, lengthClassesPmfmId);
    }

    @Override
    public List<String> getIndividualObservationPmfmId() {
        return this.editObject.getIndividualObservationPmfmId();
    }

    @Override
    public void setIndividualObservationPmfmId(List<String> individualObservationPmfmId) {
        this.editObject.setIndividualObservationPmfmId(individualObservationPmfmId);
        this.firePropertyChange("individualObservationPmfmId", null, individualObservationPmfmId);
    }

    @Override
    public List<CaracteristicMappingRow> getCaracteristicMapping() {
        return this.editObject.getCaracteristicMapping();
    }

    @Override
    public void setCaracteristicMapping(List<CaracteristicMappingRow> caracteristicMapping) {
        this.editObject.setCaracteristicMapping(caracteristicMapping);
        this.firePropertyChange("caracteristicMapping", null, caracteristicMapping);
    }

    @Override
    public CaracteristicMappingRow getCaracteristicMapping(int index) {
        return this.editObject.getCaracteristicMapping(index);
    }

    @Override
    public boolean isCaracteristicMappingEmpty() {
        return this.editObject.isCaracteristicMappingEmpty();
    }

    @Override
    public int sizeCaracteristicMapping() {
        return this.editObject.sizeCaracteristicMapping();
    }

    @Override
    public void addCaracteristicMapping(CaracteristicMappingRow caracteristicMapping) {
        this.editObject.addCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public void addAllCaracteristicMapping(Collection<CaracteristicMappingRow> caracteristicMapping) {
        this.editObject.addAllCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public boolean removeCaracteristicMapping(CaracteristicMappingRow caracteristicMapping) {
        return this.editObject.removeCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public boolean removeAllCaracteristicMapping(Collection<CaracteristicMappingRow> caracteristicMapping) {
        return this.editObject.removeAllCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public boolean containsCaracteristicMapping(CaracteristicMappingRow caracteristicMapping) {
        return this.editObject.containsCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public boolean containsAllCaracteristicMapping(Collection<CaracteristicMappingRow> caracteristicMapping) {
        return this.editObject.containsAllCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public String getIndividualObservationPmfmId(int index) {
        return this.editObject.getIndividualObservationPmfmId(index);
    }

    @Override
    public boolean isIndividualObservationPmfmIdEmpty() {
        return this.editObject.isIndividualObservationPmfmIdEmpty();
    }

    @Override
    public int sizeIndividualObservationPmfmId() {
        return this.editObject.sizeIndividualObservationPmfmId();
    }

    @Override
    public void addIndividualObservationPmfmId(String individualObservationPmfmId) {
        this.editObject.addIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public void addAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        this.editObject.addAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean removeIndividualObservationPmfmId(String individualObservationPmfmId) {
        return this.editObject.removeIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean removeAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        return this.editObject.removeAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean containsIndividualObservationPmfmId(String individualObservationPmfmId) {
        return this.editObject.containsIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean containsAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        return this.editObject.containsAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public String getLengthClassesPmfmId(int index) {
        return this.editObject.getLengthClassesPmfmId(index);
    }

    @Override
    public boolean isLengthClassesPmfmIdEmpty() {
        return this.editObject.isLengthClassesPmfmIdEmpty();
    }

    @Override
    public int sizeLengthClassesPmfmId() {
        return this.editObject.sizeLengthClassesPmfmId();
    }

    @Override
    public void addLengthClassesPmfmId(String lengthClassesPmfmId) {
        this.editObject.addLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
    }

    @Override
    public void addAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        this.editObject.addAllLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
    }

    @Override
    public boolean removeLengthClassesPmfmId(String lengthClassesPmfmId) {
        boolean result = this.editObject.removeLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
        return result;
    }

    @Override
    public boolean removeAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        boolean result = this.editObject.removeAllLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
        return result;
    }

    @Override
    public boolean containsLengthClassesPmfmId(String lengthClassesPmfmId) {
        return this.editObject.containsLengthClassesPmfmId(lengthClassesPmfmId);
    }

    @Override
    public boolean containsAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        return this.editObject.containsAllLengthClassesPmfmId(lengthClassesPmfmId);
    }

    @Override
    public SpeciesProtocol getSpecies(int index) {
        return this.editObject.getSpecies(index);
    }

    @Override
    public boolean isSpeciesEmpty() {
        return this.editObject.isSpeciesEmpty();
    }

    @Override
    public int sizeSpecies() {
        return this.editObject.sizeSpecies();
    }

    @Override
    public void addSpecies(SpeciesProtocol species) {
        this.editObject.addSpecies(species);
    }

    @Override
    public void addAllSpecies(Collection<SpeciesProtocol> species) {
        this.editObject.addAllSpecies(species);
    }

    @Override
    public boolean removeSpecies(SpeciesProtocol species) {
        return this.editObject.removeSpecies(species);
    }

    @Override
    public boolean removeAllSpecies(Collection<SpeciesProtocol> species) {
        return this.editObject.removeAllSpecies(species);
    }

    @Override
    public boolean containsSpecies(SpeciesProtocol species) {
        return this.editObject.containsSpecies(species);
    }

    @Override
    public boolean containsAllSpecies(Collection<SpeciesProtocol> species) {
        return this.editObject.containsAllSpecies(species);
    }

    @Override
    public List<SpeciesProtocol> getSpecies() {
        return this.editObject.getSpecies();
    }

    @Override
    public void setSpecies(List<SpeciesProtocol> species) {
        this.editObject.setSpecies(species);
    }

    @Override
    public SpeciesProtocol getBenthos(int index) {
        return this.editObject.getBenthos(index);
    }

    @Override
    public boolean isBenthosEmpty() {
        return this.editObject.isBenthosEmpty();
    }

    @Override
    public int sizeBenthos() {
        return this.editObject.sizeBenthos();
    }

    @Override
    public void addBenthos(SpeciesProtocol benthos) {
        this.editObject.addBenthos(benthos);
    }

    @Override
    public void addAllBenthos(Collection<SpeciesProtocol> benthos) {
        this.editObject.addAllBenthos(benthos);
    }

    @Override
    public boolean removeBenthos(SpeciesProtocol benthos) {
        return this.editObject.removeBenthos(benthos);
    }

    @Override
    public boolean removeAllBenthos(Collection<SpeciesProtocol> benthos) {
        return this.editObject.removeAllBenthos(benthos);
    }

    @Override
    public boolean containsBenthos(SpeciesProtocol benthos) {
        return this.editObject.containsBenthos(benthos);
    }

    @Override
    public boolean containsAllBenthos(Collection<SpeciesProtocol> benthos) {
        return this.editObject.containsAllBenthos(benthos);
    }

    @Override
    public List<SpeciesProtocol> getBenthos() {
        return this.editObject.getBenthos();
    }

    @Override
    public void setBenthos(List<SpeciesProtocol> benthos) {
        this.editObject.setBenthos(benthos);
    }

    @Override
    public Integer getVersion() {
        return this.editObject.getVersion();
    }

    @Override
    public void setVersion(Integer version) {
        this.editObject.setVersion(version);
    }

    @Override
    public String getImportColumns(int index) {
        return this.editObject.getImportColumns(index);
    }

    @Override
    public boolean isImportColumnsEmpty() {
        return this.editObject.isImportColumnsEmpty();
    }

    @Override
    public int sizeImportColumns() {
        return this.editObject.sizeImportColumns();
    }

    @Override
    public void addImportColumns(String importColumns) {
        this.editObject.addImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
    }

    @Override
    public void addAllImportColumns(Collection<String> importColumns) {
        this.editObject.addAllImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
    }

    @Override
    public boolean removeImportColumns(String importColumns) {
        boolean removeImportColumns = this.editObject.removeImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
        return removeImportColumns;
    }

    @Override
    public boolean removeAllImportColumns(Collection<String> importColumns) {
        boolean removeAllImportColumns = this.editObject.removeAllImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
        return removeAllImportColumns;
    }

    @Override
    public boolean containsImportColumns(String importColumns) {
        return this.editObject.containsImportColumns(importColumns);
    }

    @Override
    public boolean containsAllImportColumns(Collection<String> importColumns) {
        return this.editObject.containsAllImportColumns(importColumns);
    }

    @Override
    public Collection<String> getImportColumns() {
        return this.editObject.getImportColumns();
    }

    @Override
    public void setImportColumns(Collection<String> importColumns) {
        this.editObject.setImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
    }

    @Override
    public void setOperationFieldMapping(Collection<OperationFieldMappingRow> operationFieldMapping) {
        this.editObject.setOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
    }

    @Override
    public Collection<OperationFieldMappingRow> getOperationFieldMapping() {
        return this.editObject.getOperationFieldMapping();
    }

    @Override
    public boolean containsAllOperationFieldMapping(Collection<OperationFieldMappingRow> operationFieldMapping) {
        return this.editObject.containsAllOperationFieldMapping(operationFieldMapping);
    }

    @Override
    public boolean containsOperationFieldMapping(OperationFieldMappingRow operationFieldMapping) {
        return this.editObject.containsOperationFieldMapping(operationFieldMapping);
    }

    @Override
    public boolean removeAllOperationFieldMapping(Collection<OperationFieldMappingRow> operationFieldMapping) {
        boolean removeAllOperationFieldMapping = this.editObject.removeAllOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
        return removeAllOperationFieldMapping;
    }

    @Override
    public boolean removeOperationFieldMapping(OperationFieldMappingRow operationFieldMapping) {
        boolean removeOperationFieldMapping = this.editObject.removeOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
        return removeOperationFieldMapping;
    }

    @Override
    public void addAllOperationFieldMapping(Collection<OperationFieldMappingRow> operationFieldMapping) {
        this.editObject.addAllOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
    }

    @Override
    public void addOperationFieldMapping(OperationFieldMappingRow operationFieldMapping) {
        this.editObject.addOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
    }

    @Override
    public int sizeOperationFieldMapping() {
        return this.editObject.sizeOperationFieldMapping();
    }

    @Override
    public boolean isOperationFieldMappingEmpty() {
        return this.editObject.isOperationFieldMappingEmpty();
    }

    @Override
    public OperationFieldMappingRow getOperationFieldMapping(int index) {
        return this.editObject.getOperationFieldMapping(index);
    }

    public int numberOfRows(String column) {
        int result = 0;
        MutableInt mutableInt = this.numberOfRowsByColumn.get(column);
        if (mutableInt != null) {
            result = mutableInt.intValue();
        }
        return result;
    }

    public void resetNumbersOfRows() {
        this.numberOfRowsByColumn = new HashMap<String, MutableInt>();
    }

    public int incNumberOfRows(String column) {
        MutableInt mutableInt = this.numberOfRowsByColumn.get(column);
        if (mutableInt == null) {
            mutableInt = new MutableInt(1);
            this.numberOfRowsByColumn.put(column, mutableInt);
        } else {
            mutableInt.increment();
        }
        return mutableInt.intValue();
    }

    public int decNumberOfRows(String column) {
        MutableInt mutableInt = this.numberOfRowsByColumn.get(column);
        Preconditions.checkNotNull((Object)mutableInt);
        Preconditions.checkArgument((mutableInt.intValue() > 0 ? 1 : 0) != 0);
        mutableInt.decrement();
        return mutableInt.intValue();
    }
}

