/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageProperties;
import org.apache.poi.openxml4j.util.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackagePropertiesPart
extends PackagePart
implements PackageProperties {
    public static final String NAMESPACE_DC_URI = "http://purl.org/dc/elements/1.1/";
    public static final String NAMESPACE_CP_URI = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    public static final String NAMESPACE_DCTERMS_URI = "http://purl.org/dc/terms/";
    public static final String NAMESPACE_XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    protected Nullable<String> category = new Nullable();
    protected Nullable<String> contentStatus = new Nullable();
    protected Nullable<String> contentType = new Nullable();
    protected Nullable<Date> created = new Nullable();
    protected Nullable<String> creator = new Nullable();
    protected Nullable<String> description = new Nullable();
    protected Nullable<String> identifier = new Nullable();
    protected Nullable<String> keywords = new Nullable();
    protected Nullable<String> language = new Nullable();
    protected Nullable<String> lastModifiedBy = new Nullable();
    protected Nullable<Date> lastPrinted = new Nullable();
    protected Nullable<Date> modified = new Nullable();
    protected Nullable<String> revision = new Nullable();
    protected Nullable<String> subject = new Nullable();
    protected Nullable<String> title = new Nullable();
    protected Nullable<String> version = new Nullable();

    public PackagePropertiesPart(OPCPackage pack, PackagePartName partName) throws InvalidFormatException {
        super(pack, partName, "application/vnd.openxmlformats-package.core-properties+xml");
    }

    @Override
    public Nullable<String> getCategoryProperty() {
        return this.category;
    }

    @Override
    public Nullable<String> getContentStatusProperty() {
        return this.contentStatus;
    }

    @Override
    public Nullable<String> getContentTypeProperty() {
        return this.contentType;
    }

    @Override
    public Nullable<Date> getCreatedProperty() {
        return this.created;
    }

    public String getCreatedPropertyString() {
        return this.getDateValue(this.created);
    }

    @Override
    public Nullable<String> getCreatorProperty() {
        return this.creator;
    }

    @Override
    public Nullable<String> getDescriptionProperty() {
        return this.description;
    }

    @Override
    public Nullable<String> getIdentifierProperty() {
        return this.identifier;
    }

    @Override
    public Nullable<String> getKeywordsProperty() {
        return this.keywords;
    }

    @Override
    public Nullable<String> getLanguageProperty() {
        return this.language;
    }

    @Override
    public Nullable<String> getLastModifiedByProperty() {
        return this.lastModifiedBy;
    }

    @Override
    public Nullable<Date> getLastPrintedProperty() {
        return this.lastPrinted;
    }

    public String getLastPrintedPropertyString() {
        return this.getDateValue(this.lastPrinted);
    }

    @Override
    public Nullable<Date> getModifiedProperty() {
        return this.modified;
    }

    public String getModifiedPropertyString() {
        if (this.modified.hasValue()) {
            return this.getDateValue(this.modified);
        }
        return this.getDateValue(new Nullable<Date>(new Date()));
    }

    @Override
    public Nullable<String> getRevisionProperty() {
        return this.revision;
    }

    @Override
    public Nullable<String> getSubjectProperty() {
        return this.subject;
    }

    @Override
    public Nullable<String> getTitleProperty() {
        return this.title;
    }

    @Override
    public Nullable<String> getVersionProperty() {
        return this.version;
    }

    @Override
    public void setCategoryProperty(String category) {
        this.category = this.setStringValue(category);
    }

    @Override
    public void setContentStatusProperty(String contentStatus) {
        this.contentStatus = this.setStringValue(contentStatus);
    }

    @Override
    public void setContentTypeProperty(String contentType) {
        this.contentType = this.setStringValue(contentType);
    }

    @Override
    public void setCreatedProperty(String created) {
        try {
            this.created = this.setDateValue(created);
        }
        catch (InvalidFormatException e) {
            new IllegalArgumentException("created  : " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setCreatedProperty(Nullable<Date> created) {
        if (created.hasValue()) {
            this.created = created;
        }
    }

    @Override
    public void setCreatorProperty(String creator) {
        this.creator = this.setStringValue(creator);
    }

    @Override
    public void setDescriptionProperty(String description) {
        this.description = this.setStringValue(description);
    }

    @Override
    public void setIdentifierProperty(String identifier) {
        this.identifier = this.setStringValue(identifier);
    }

    @Override
    public void setKeywordsProperty(String keywords) {
        this.keywords = this.setStringValue(keywords);
    }

    @Override
    public void setLanguageProperty(String language) {
        this.language = this.setStringValue(language);
    }

    @Override
    public void setLastModifiedByProperty(String lastModifiedBy) {
        this.lastModifiedBy = this.setStringValue(lastModifiedBy);
    }

    @Override
    public void setLastPrintedProperty(String lastPrinted) {
        try {
            this.lastPrinted = this.setDateValue(lastPrinted);
        }
        catch (InvalidFormatException e) {
            new IllegalArgumentException("lastPrinted  : " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setLastPrintedProperty(Nullable<Date> lastPrinted) {
        if (lastPrinted.hasValue()) {
            this.lastPrinted = lastPrinted;
        }
    }

    @Override
    public void setModifiedProperty(String modified) {
        try {
            this.modified = this.setDateValue(modified);
        }
        catch (InvalidFormatException e) {
            new IllegalArgumentException("modified  : " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setModifiedProperty(Nullable<Date> modified) {
        if (modified.hasValue()) {
            this.modified = modified;
        }
    }

    @Override
    public void setRevisionProperty(String revision) {
        this.revision = this.setStringValue(revision);
    }

    @Override
    public void setSubjectProperty(String subject) {
        this.subject = this.setStringValue(subject);
    }

    @Override
    public void setTitleProperty(String title) {
        this.title = this.setStringValue(title);
    }

    @Override
    public void setVersionProperty(String version) {
        this.version = this.setStringValue(version);
    }

    private Nullable<String> setStringValue(String s) {
        if (s == null || s.equals("")) {
            return new Nullable<String>();
        }
        return new Nullable<String>(s);
    }

    private Nullable<Date> setDateValue(String s) throws InvalidFormatException {
        if (s == null || s.equals("")) {
            return new Nullable<Date>();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date d = df.parse(s, new ParsePosition(0));
        if (d == null) {
            throw new InvalidFormatException("Date not well formated");
        }
        return new Nullable<Date>(d);
    }

    private String getDateValue(Nullable<Date> d) {
        if (d == null) {
            return "";
        }
        Date date = d.getValue();
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    @Override
    protected InputStream getInputStreamImpl() {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    protected OutputStream getOutputStreamImpl() {
        throw new InvalidOperationException("Can't use output stream to set properties !");
    }

    @Override
    public boolean save(OutputStream zos) {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    public boolean load(InputStream ios) {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

