/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.session;

import java.util.List;
import java.util.Map;
import jaxx.runtime.swing.session.JTableState;
import jaxx.runtime.swing.session.State;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class JXTableSwingSessionState
extends JTableState {
    protected boolean[] hiddenColumns;

    public JXTableSwingSessionState() {
    }

    public JXTableSwingSessionState(int[] columnWidths, Map<Integer, String> sortKeys, boolean[] hiddenColumns) {
        super(columnWidths, sortKeys);
        this.hiddenColumns = hiddenColumns;
    }

    public boolean[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(boolean[] hiddenColumns) {
        this.hiddenColumns = hiddenColumns;
    }

    protected JXTable checkComponent(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(o instanceof JXTable)) {
            throw new IllegalArgumentException("invalid component");
        }
        return (JXTable)o;
    }

    @Override
    public State getState(Object o) {
        JXTable table = this.checkComponent(o);
        JXTableSwingSessionState result = new JXTableSwingSessionState();
        JTableState state = (JTableState)super.getState(o);
        if (state != null) {
            result.setColumnWidths(state.getColumnWidths());
            result.setSortKeys(state.getSortKeys());
        }
        DefaultTableColumnModelExt columnModel = (DefaultTableColumnModelExt)table.getColumnModel();
        List columns = columnModel.getColumns(true);
        boolean[] hiddenColumns = new boolean[columns.size()];
        for (int i = 0; i < hiddenColumns.length; ++i) {
            TableColumnExt tc = (TableColumnExt)columns.get(i);
            hiddenColumns[i] = !tc.isVisible();
        }
        result.setHiddenColumns(hiddenColumns);
        return result;
    }

    @Override
    public void setState(Object o, State state) {
        if (!(state instanceof JXTableSwingSessionState)) {
            throw new IllegalArgumentException("invalid state");
        }
        super.setState(o, state);
        JXTable table = this.checkComponent(o);
        boolean[] hiddenColumns = ((JXTableSwingSessionState)state).getHiddenColumns();
        DefaultTableColumnModelExt columnModel = (DefaultTableColumnModelExt)table.getColumnModel();
        List columns = columnModel.getColumns(true);
        if (hiddenColumns != null && hiddenColumns.length == columns.size()) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                TableColumnExt tc = (TableColumnExt)columns.get(i);
                tc.setVisible(!hiddenColumns[i]);
            }
        }
    }
}

