/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class SynchroJoinMetadata {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SynchroJoinMetadata.class.getName());
    protected SynchroTableMetadata sourceTable;
    protected SynchroColumnMetadata sourceColumn;
    protected SynchroColumnMetadata targetColumn;
    protected SynchroTableMetadata targetTable;
    protected boolean isValid = false;
    protected boolean isChild = false;
    protected boolean isSourceFk = false;

    public SynchroJoinMetadata(ResultSet rs, SynchroTableMetadata table, SynchroDatabaseMetadata meta) throws SQLException {
        String pkTableName = rs.getString("PKTABLE_NAME").toLowerCase();
        String pkColumnName = rs.getString("PKCOLUMN_NAME").toLowerCase();
        String fkTableName = rs.getString("FKTABLE_NAME").toLowerCase();
        String fkColumnName = rs.getString("FKCOLUMN_NAME").toLowerCase();
        SynchroTableMetadata pkTable = meta.getLoadedTable(pkTableName);
        SynchroColumnMetadata pkColumn = null;
        if (pkTable == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("[%s] Ignore join to %s: table not found", table.getName(), pkTableName.toUpperCase()));
            }
            return;
        }
        pkColumn = pkTable.getColumn(pkColumnName);
        if (pkColumn == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("[%s] Ignore join to %s: column %s not found", table.getName(), pkTableName.toUpperCase(), pkColumnName.toUpperCase()));
            }
            return;
        }
        SynchroTableMetadata fkTable = meta.getLoadedTable(fkTableName);
        SynchroColumnMetadata fkColumn = null;
        if (fkTable != null) {
            fkColumn = fkTable.getColumn(fkColumnName);
        }
        if (fkTable == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("[%s] Ignore join from %s: table not found", table.getName(), fkTableName.toUpperCase()));
            }
            return;
        }
        if (fkTable == null || fkColumn == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("[%s] Ignore join from %s: column %s not found", table.getName(), fkTableName.toUpperCase(), fkColumnName.toUpperCase()));
            }
            return;
        }
        if (pkTable == table) {
            this.sourceTable = pkTable;
            this.sourceColumn = pkColumn;
            this.targetTable = fkTable;
            this.targetColumn = fkColumn;
            this.isChild = true;
            this.isSourceFk = false;
        } else {
            this.sourceTable = fkTable;
            this.sourceColumn = fkColumn;
            this.targetTable = pkTable;
            this.targetColumn = pkColumn;
            this.isChild = false;
            this.isSourceFk = true;
        }
        this.isValid = true;
    }

    public SynchroJoinMetadata(SynchroTableMetadata table, SynchroTableMetadata pkTable, SynchroColumnMetadata pkColumn, SynchroTableMetadata fkTable, SynchroColumnMetadata fkColumn) {
        if (pkTable == table) {
            this.sourceTable = pkTable;
            this.sourceColumn = pkColumn;
            this.targetTable = fkTable;
            this.targetColumn = fkColumn;
            this.isChild = true;
            this.isSourceFk = false;
        } else {
            this.sourceTable = fkTable;
            this.sourceColumn = fkColumn;
            this.targetTable = pkTable;
            this.targetColumn = pkColumn;
            this.isChild = false;
            this.isSourceFk = true;
        }
        this.isValid = true;
    }

    public boolean isChild() {
        return this.isChild;
    }

    public int hashCode() {
        return this.sourceColumn.hashCode() + this.targetColumn.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SynchroJoinMetadata) {
            SynchroJoinMetadata otherJoin = (SynchroJoinMetadata)obj;
            return this.sourceColumn.equals(otherJoin.sourceColumn) && this.targetColumn.equals(otherJoin.targetColumn);
        }
        return this.equals(obj);
    }

    public SynchroTableMetadata getTargetTable() {
        return this.targetTable;
    }

    public SynchroColumnMetadata getTargetColumn() {
        return this.targetColumn;
    }

    public SynchroTableMetadata getSourceTable() {
        return this.sourceTable;
    }

    public SynchroColumnMetadata getSourceColumn() {
        return this.sourceColumn;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setIsValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String toString() {
        return String.format("JoinMetadata(%s.%s = %s.%s)", this.sourceTable.getName(), this.sourceColumn.getName(), this.targetTable.getName(), this.targetColumn.getName());
    }

    public boolean isSourceFk() {
        return this.isSourceFk;
    }

    public boolean isTargetPk() {
        return !this.isSourceFk;
    }

    public SynchroTableMetadata getPkTable() {
        return !this.isSourceFk ? this.sourceTable : this.targetTable;
    }

    public SynchroColumnMetadata getPkColumn() {
        return !this.isSourceFk ? this.sourceColumn : this.targetColumn;
    }

    public SynchroTableMetadata getFkTable() {
        return this.isSourceFk ? this.sourceTable : this.targetTable;
    }

    public SynchroColumnMetadata getFkColumn() {
        return this.isSourceFk ? this.sourceColumn : this.targetColumn;
    }
}

