/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.DBObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;

public class ArrayFieldValues {
    private Map<String, Object> m_fieldValues = new LinkedHashMap<String, Object>(5);
    private String m_containingDocName;
    private int m_subRowIndex = 0;
    private int m_maxSubRows = 0;

    ArrayFieldValues(String containingDocName) {
        this.m_containingDocName = containingDocName;
    }

    boolean hasFieldValue(String fieldName) {
        return this.m_fieldValues.containsKey(fieldName);
    }

    Object getFieldValue(String fieldName) {
        return this.m_fieldValues.get(fieldName);
    }

    void addFieldValue(MDbMetaData.FieldMetaData fieldMD, List<?> value) {
        String fieldName = fieldMD.getFullName();
        this.addFieldValue(fieldName, value, true);
    }

    void addFieldValue(String fieldName, Object value, boolean iterateListElements) {
        this.m_fieldValues.put(fieldName, value);
        int valueRowCount = 1;
        if (iterateListElements && value instanceof List) {
            valueRowCount = ((List)value).size();
        }
        if (this.m_maxSubRows < valueRowCount) {
            this.m_maxSubRows = valueRowCount;
        }
    }

    boolean hasContainerDocs() {
        return this.hasFieldValue(this.m_containingDocName);
    }

    void addContainerDocs(DBObject value) {
        this.addFieldValue(this.m_containingDocName, value, true);
    }

    void clearContainerDocs() {
        if ("".equals(this.m_containingDocName)) {
            return;
        }
        if (!this.m_fieldValues.isEmpty()) {
            this.m_fieldValues.remove(this.m_containingDocName);
        }
        this.resetRowCount();
    }

    Object getCurrentValue(String fieldName) {
        Object value = this.getFieldValue(fieldName);
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            return value;
        }
        List fieldValuesList = (List)value;
        if (this.m_subRowIndex < 0 || this.m_subRowIndex >= fieldValuesList.size()) {
            return null;
        }
        return fieldValuesList.get(this.m_subRowIndex);
    }

    DBObject getCurrentContainerDoc() {
        Object currentDoc = this.getCurrentValue(this.m_containingDocName);
        return currentDoc instanceof DBObject ? (DBObject)currentDoc : null;
    }

    boolean next() {
        if (this.m_subRowIndex + 1 < this.m_maxSubRows) {
            ++this.m_subRowIndex;
            return true;
        }
        this.resetIterator();
        return false;
    }

    private void resetIterator() {
        this.m_subRowIndex = 0;
    }

    void clear() {
        if (!this.m_fieldValues.isEmpty()) {
            this.m_fieldValues.clear();
        }
        this.resetRowCount();
    }

    private void resetRowCount() {
        if (this.m_fieldValues.isEmpty()) {
            this.m_maxSubRows = 0;
            this.resetIterator();
            return;
        }
        for (Object fieldValue : this.m_fieldValues.values()) {
            int valueRowCount;
            int n = valueRowCount = fieldValue instanceof List ? ((List)fieldValue).size() : 1;
            if (this.m_maxSubRows >= valueRowCount) continue;
            this.m_maxSubRows = valueRowCount;
        }
    }
}

