/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class GenericFormatReferentialImportResult<E extends TuttiReferentialEntity, K extends Comparable<K>>
extends GenericFormatCsvFileResult {
    private static final long serialVersionUID = 1L;
    protected Map<String, E> entitiesAdded = Collections.emptyMap();
    protected Map<String, E> entitiesLinked = Collections.emptyMap();
    private Map<String, String> idTranslationMap = Collections.emptyMap();

    public GenericFormatReferentialImportResult(String filename, boolean found) {
        super(filename, false, found);
    }

    public void flushResult(ReferentialImportRequest<E, K> importRequest, ReferentialImportResult<E> importResult) {
        TreeMap<String, String> translationMap = new TreeMap<String, String>();
        Function<E, K> entityToIdFunction = importRequest.getEntityToIdFunction();
        int nbRefAdded = importResult.getNbRefAdded();
        List<E> toAdds = importRequest.getEntitiesToAdd();
        List<E> addeds = importResult.getRefAdded();
        this.entitiesAdded = this.merge(entityToIdFunction, nbRefAdded, toAdds, addeds, translationMap);
        int nbRefLinked = importResult.getNbRefLinked();
        List<E> toLinks = importRequest.getEntitiesToLink();
        List<E> linkeds = importResult.getRefLinked();
        this.entitiesLinked = this.merge(entityToIdFunction, nbRefLinked, toLinks, linkeds, translationMap);
        this.idTranslationMap = Collections.unmodifiableMap(translationMap);
    }

    public Set<Map.Entry<String, E>> getEntitiesAddedEntries() {
        return this.entitiesAdded.entrySet();
    }

    public Collection<E> getEntitiesAdded() {
        return this.entitiesAdded.values();
    }

    public Set<Map.Entry<String, E>> getEntitiesLinkedEntries() {
        return this.entitiesLinked.entrySet();
    }

    public Map<String, String> getIdTranslationMap() {
        return this.idTranslationMap;
    }

    protected Map<String, E> merge(Function<E, K> entityToIdFunction, int nbEntities, List<E> request, List<E> result, Map<String, String> translationMap) {
        TreeMap<String, TuttiReferentialEntity> mergeMap = new TreeMap<String, TuttiReferentialEntity>();
        for (int index = 0; index < nbEntities; ++index) {
            TuttiReferentialEntity toAdd = (TuttiReferentialEntity)request.get(index);
            Comparable toAddId = (Comparable)entityToIdFunction.apply((Object)toAdd);
            String originalId = String.valueOf(toAddId);
            TuttiReferentialEntity added = (TuttiReferentialEntity)result.get(index);
            Comparable addedId = (Comparable)entityToIdFunction.apply((Object)added);
            String targetId = String.valueOf(addedId);
            mergeMap.put(originalId, added);
            translationMap.put(originalId, targetId);
        }
        return Collections.unmodifiableMap(mergeMap);
    }

    public String getReport() {
        List<String> linked;
        List<String> added;
        StringBuilder builder = new StringBuilder();
        Set<Map.Entry<Long, Set<String>>> errors = this.getErrorsEntries();
        if (!errors.isEmpty()) {
            builder.append(String.format("%s lines in error:", errors.size()));
            for (Map.Entry<Long, Set<String>> entry : errors) {
                Long lineNumber = entry.getKey();
                Set<String> error = entry.getValue();
                builder.append(String.format("\nline %s : \n%s", lineNumber, Joiner.on((String)"\n\t").join(error)));
            }
        }
        if (!(added = this.getMapReport(this.entitiesAdded)).isEmpty()) {
            builder.append(String.format("\n%s entities added: \n%s", added.size(), Joiner.on((String)"\n").join(added)));
        }
        if (!(linked = this.getMapReport(this.entitiesLinked)).isEmpty()) {
            builder.append(String.format("\n%s entities linked: \n%s", linked.size(), Joiner.on((String)"\n").join(linked)));
        }
        return builder.toString();
    }

    protected List<String> getMapReport(Map<String, E> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.idTranslationMap.entrySet()) {
            String originalId = entry.getKey();
            String targetId = entry.getValue();
            if (!map.containsKey(originalId)) continue;
            list.add(String.format("original id: %s -> persist id: %s", originalId, targetId));
        }
        return list;
    }
}

