/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.rtp;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.rtp.RtpEditorUI;
import fr.ifremer.tutti.ui.swing.content.protocol.rtp.RtpEditorUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.RowSorter;
import jaxx.runtime.swing.ComponentMover;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class RtpEditorUIHandler
extends AbstractTuttiUIHandler<RtpEditorUIModel, RtpEditorUI> {
    private static final Log log = LogFactory.getLog(RtpEditorUIHandler.class);

    public void beforeInit(RtpEditorUI ui) {
        super.beforeInit((ApplicationUI)ui);
        RtpEditorUIModel model = new RtpEditorUIModel();
        ((RtpEditorUI)this.ui).setContextValue(model);
    }

    public void afterInit(RtpEditorUI ui) {
        super.initUI((ApplicationUI)ui);
        ui.pack();
        ComponentMover cm = new ComponentMover();
        cm.registerComponent(new Component[]{ui});
        ui.getBodyPanel().setRightDecoration((JComponent)ui.getHeaderToolBar());
        RtpEditorUIModel model = (RtpEditorUIModel)this.getModel();
        this.listModelIsModify(model);
        this.listenValidatorValid((SimpleBeanValidator)ui.getValidator(), model);
        model.addPropertyChangeListener("row", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditProtocolSpeciesRowModel rowModel = ((RtpEditorUIModel)RtpEditorUIHandler.this.getModel()).getRowModel();
                Species species = rowModel.getSpecies();
                String decorate = RtpEditorUIHandler.this.decorate(species);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Edit RTP for species: " + decorate));
                }
                ((RtpEditorUI)RtpEditorUIHandler.this.getUI()).getBodyPanel().setTitle(I18n.t((String)"tutti.rtpEdit.title", (Object[])new Object[]{decorate}));
            }
        });
    }

    protected JComponent getComponentToFocus() {
        return ((RtpEditorUI)this.getUI()).getRtpMaleAField();
    }

    public void onCloseUI() {
        boolean result = this.quitUI();
        if (result) {
            ((RtpEditorUIModel)this.getModel()).reset();
            ((RtpEditorUI)this.ui).dispose();
        }
    }

    public boolean quitUI() {
        boolean result = true;
        RtpEditorUIModel model = (RtpEditorUIModel)this.getModel();
        if (model.isModify()) {
            result = model.isValid() ? this.quitUnsavedRtpForm() : this.quitInvalidRtpForm();
        }
        return result;
    }

    protected boolean quitUnsavedRtpForm() {
        boolean result;
        int answer = this.askSaveBeforeLeaving(I18n.t((String)"tutti.rtpEdit.askSaveBeforeLeaving", (Object[])new Object[0]));
        switch (answer) {
            case 0: {
                this.getContext().getActionEngine().runAction((AbstractButton)((RtpEditorUI)this.ui).getSaveButton());
                result = true;
                break;
            }
            case 1: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected boolean quitInvalidRtpForm() {
        return this.askCancelEditBeforeLeaving(I18n.t((String)"tutti.rtpEdit.askCancelEditBeforeLeaving", (Object[])new Object[0]));
    }

    public SwingValidator<RtpEditorUIModel> getValidator() {
        return ((RtpEditorUI)this.ui).getValidator();
    }

    @Override
    public Component getTopestUI() {
        return (Component)this.getUI();
    }

    public void setBean(EditProtocolSpeciesTableModel tableModel, RowSorter rowSorter, int row) {
        ((RtpEditorUIModel)this.getModel()).setRowModel(tableModel, rowSorter, row);
    }

    public void openEditor() {
        ((RtpEditorUI)this.ui).setVisible(true);
    }

    public void closeEditor() {
        this.onCloseUI();
    }
}

