package fr.ifremer.tutti.ui.swing.content.referential.replace;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JButton;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ReplaceTemporaryPersonUI extends AbstractReplaceTemporaryUI<Person, ReplaceTemporaryPersonUIModel> implements TuttiUI<ReplaceTemporaryPersonUIModel, ReplaceTemporaryPersonUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1TTU8UQRCtXV1gQRTYQDBigmg89nrhoBjlw2yELEhYSIh70J6ZZrdJ70zb3SNDjMaf4E/QuxcTb56MB88evBj/gjEevBqrZ4b9gEGJcQ+VTVXXq1c1773+BgWt4NIujSKiQt/wFiMrC9vb95xd5po7TLuKSxMoSH65POTrMOS189rA5XrVtpfT9vJS0JKBz/yu7rkqDGqzL5huMmYMXOztcLUu19rluUiG6gC1TSoL9eWP7/kX3vNXeYBIIju7yvTfujqbnK5CnnsGxnDSY1oW1G8gDcX9BvIdtrklQbVeoy32CJ5BfxX6JFUIZmDm5CvHGHF/JA2MKyYFddkmww5F1f7W8maA+bUdRfiOYi2miAmN4STkRO8hF+IGvkFootgOs9M5FSRFIRuH0NaZ0oG/tSxlPLLPQKEVeEwYqP3fAasWtTNlTAehclmVa4O3cILFIDIw2/MpklnM43gc4jDqk0UMFS4MU9TBO6V9FrHYATZUNZjpBraV0d5XwyndRVwMl4GS/XhROnIlyaYdCi700ELtkY72OuLI1aGgQkwbmKwflesGlhKhTh4SqgWMq78mSp/ffX1b6VbneObTLnOhaqQKJFOG29HnEmmGhovyKpVzdShqJtCZsfOmMojV0jKSw3mjtp3YdnKX6iZCFPq/vP8w8fDTKchXYFAE1KtQ+34Ziqap8AqB8CJ5ez5mdGZvAOOI5Wagr8l4o4niz89ei3DxqYzF29Od4sefpdqb+YPlc0jm/LHPOwco3Ic+7gvus9icqe8yzTgkNQu9oOOvLMeBlOiuISeWwDr1mYgrU3GczlqzYLgRqISZxCWH/ZoYgMSPotCiXInXs/+uwnEGl6lV/jB37AGVUnCXGh74C66NBpwn/2ZbGvfrY+yboBPX3ulp1hK9fjoB+QFr6M19iXc7e9Ojhk473PeQ5a0j8DkbR/6KadPXbbiRjVBChN/BZCarvgYAAA==";
    private static final Log log = LogFactory.getLog(ReplaceTemporaryPersonUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected final ReplaceTemporaryPersonUIHandler handler = createHandler();
    protected ReplaceTemporaryPersonUIModel model;
    protected JButton replaceButton;
    protected ReplaceTemporaryPersonUI replaceTemporaryUITop = this;
    protected BeanFilterableComboBox<Person> sourceListComboBox;
    protected BeanFilterableComboBox<Person> targetListComboBox;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplaceTemporaryPersonUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI() {
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ReplaceTemporaryPersonUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplaceTemporaryPersonUIHandler getHandler() {
        return handler;
    }

    public ReplaceTemporaryPersonUIModel getModel() {
        return model;
    }

    public JButton getReplaceButton() {
        return replaceButton;
    }

    public BeanFilterableComboBox<Person> getSourceListComboBox() {
        return sourceListComboBox;
    }

    public BeanFilterableComboBox<Person> getTargetListComboBox() {
        return targetListComboBox;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplaceTemporaryUITop() {
        if (!allComponentsCreated) {
            return;
        }
        add(sourceListComboBox);
        add(targetListComboBox);
        add(replaceButton);
    }

    protected ReplaceTemporaryPersonUIHandler createHandler() {
        return new ReplaceTemporaryPersonUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReplaceTemporaryPersonUIModel.class));
    }

    protected void createReplaceButton() {
        $objectMap.put("replaceButton", replaceButton = new JButton());
        
        replaceButton.setName("replaceButton");
        replaceButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.replace.actions.ReplaceTemporaryPersonAction.class);
    }

    protected void createSourceListComboBox() {
        $objectMap.put("sourceListComboBox", sourceListComboBox = new BeanFilterableComboBox<Person>());
        
        sourceListComboBox.setName("sourceListComboBox");
    }

    protected void createTargetListComboBox() {
        $objectMap.put("targetListComboBox", targetListComboBox = new BeanFilterableComboBox<Person>());
        
        targetListComboBox.setName("targetListComboBox");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplaceTemporaryUITop();
        
        // apply 2 property setters
        sourceListComboBox.setBeanType(Person.class);
        targetListComboBox.setBeanType(Person.class);
        // late initializer
        replaceTemporaryUITop.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("replaceTemporaryUITop", replaceTemporaryUITop);
        createModel();
        createSourceListComboBox();
        createTargetListComboBox();
        createReplaceButton();
        // inline creation of replaceTemporaryUITop
        setName("replaceTemporaryUITop");
        setTitle(t("tutti.replaceTemporaryPerson.title"));
        
        $completeSetup();
        handler.afterInit(this);
    }

}