package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ImportPupitriMelagWeightPopupUI extends JDialog implements TuttiUI<ImportPupitriMelagWeightPopupUIModel, ImportPupitriMelagWeightPopupUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MELAG_WEIGHT_BEAN = "melagWeight.bean";
    public static final String BINDING_MELAG_WEIGHT_NUMBER_VALUE = "melagWeight.numberValue";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWz28bRRR+duq4tpukJbQqokWlCGiral0OSEhBpcHBIpWTRrX7Q/jQjr0Te6rZnWHnbeMoKuJP4E+AOxckbpwQB84cuCD+BYQ4cEW8mV2v7WaNK6H6sLuaee9933vzvjf+9g8omQjefMJGIy+KQxQB925vPnx4p/eE93GLm34kNKoIkl+hCMUu1Pxs3SC81W1Z93rqXm+oQKuQh1PeGy2oGjyU3Aw5R4SLsx59Y+rtbHtjpONoHDUjlRf167/+LH7lf/lNEWCkiV2ZUrm0yGuSyYkWFIWP8AohPWV1ycIB0YhEOCC+K3atIZkxuyzgn8MXUG7BsmYRBUO4/OIpuxjOf6QR3hBkGeFerAUh7XDJBg+4GAxxSzCpBgjd/cgT+xEPeORhjCi8WHjmgEh5fRUiYXhK84ihUKHXZ9gfcuMZzfuC3ttzgu8pHet721o7IssIpUD5XCI8foloOxZiAlkJmAj3WGhhz88cUoLXYT3p6lzJXMoBN4YNOB2RPY1Ranm7xXpcWpu1zPR0MMHPtl+dtalN2SDcnJ96jEJS/oGO0ZJyXZR8bjFkn/iCznc29OpTJoXPkH9MkahwsD5DOFlNXSJ4fSZ96n5v0v2T9ix0oRTFtEz16h4XzF3aSqRy/jmp2IBu959z67/+8Pv3zWl9nM01nZI39a2O7KGjsNBriThsSeo7TG90oWK4pNngtH8hh1g73SZyhHfGuicV/ZSZIYUolX/78adzj39ZgmITqlIxv8ms/TZUcBhRFZT0R/qjW47RqYOT9DxtuSEsD9OzK75/Y0SJX8hJPEPvVX7+e7393a1x8gUi89pc80kBSp/BsgilCLkbD6nyc8dBTRse+2qi8DzNg9ak+1rPtYDrf7dz2T3fOZZmkcSJAiV1wttJW85MDG+qh73UzoqZkapOYBTzUWzjXnMJ26/rsHDo6FSk8ygVbGg+orq/u4hRKtg8EmMxL0JbQjgprYKbhAErR1Phn2VEFpZmX3BJo331EfP9ZOleKMjx+tGQhb4kzdNYaahwXwyuXLXf7WSoTWyvXH2Wl8axQbMonzLCmWSWcN+Oj4aSNrH6PCJuv5E6JDiGuNAAZTEqN1vneQuzOTbZjYMej5JR5byroVvpHGpuq9ok3aHXt31Km2skugPnN55fN+YAtMlwOnZi7xBqCcJ9JmOCuHjkrhjr3lHI5FTXJdlYyLvc2L8DrnHp1eOMoK/leY4LcifaVZiFyTug6Sm/6GxKCKfEex+EOyEPVCj6JJWksejAaMEbT3UvyAyqNKvoMty21yMsUXdlPXk215UIoVKyI3TnP61WHhnqZsk3XXiEg6P/czUnJBdc0fdT8AQybYa8kj53u73AvFiW7FCRMax+SH7sUk+EPjG/eSx6wT6rFPFfjquFkYoKAAA=";
    private static final Log log = LogFactory.getLog(ImportPupitriMelagWeightPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected final ImportPupitriMelagWeightPopupUIHandler handler = createHandler();
    protected ImportPupitriMelagWeightPopupUI importPupitriMelagWeightDialog = this;
    protected Table mainPanel;
    protected ComputableDataEditor<Float> melagWeight;
    protected JLabel melagWeightLabel;
    protected JLabel message;
    protected ImportPupitriMelagWeightPopupUIModel model;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void open(float initialWeight) {
        handler.open(initialWeight);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportPupitriMelagWeightPopupUI(TuttiUI parentUI) {
        super(parentUI.getHandler().getContext().getMainUI());
            TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI() {
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriMelagWeightPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportPupitriMelagWeightPopupUIHandler getHandler() {
        return handler;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public ComputableDataEditor<Float> getMelagWeight() {
        return melagWeight;
    }

    public JLabel getMelagWeightLabel() {
        return melagWeightLabel;
    }

    public JLabel getMessage() {
        return message;
    }

    public ImportPupitriMelagWeightPopupUIModel getModel() {
        return model;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToImportPupitriMelagWeightDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(message, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(melagWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(melagWeight, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(validateButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected ImportPupitriMelagWeightPopupUIHandler createHandler() {
        return new ImportPupitriMelagWeightPopupUIHandler();
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createMelagWeight() {
        $objectMap.put("melagWeight", melagWeight = new ComputableDataEditor<Float>(this));
        
        melagWeight.setName("melagWeight");
        melagWeight.setShowReset(true);
    }

    protected void createMelagWeightLabel() {
        $objectMap.put("melagWeightLabel", melagWeightLabel = new JLabel());
        
        melagWeightLabel.setName("melagWeightLabel");
        melagWeightLabel.setText(t("tutti.importPupitri.melagWeight.field"));
        melagWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JLabel());
        
        message.setName("message");
        message.setText(t("tutti.importPupitri.melagWeight.message"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ImportPupitriMelagWeightPopupUIModel.class));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("tutti.common.validate"));
        validateButton.setToolTipText(t("tutti.common.validate"));
        validateButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.species.actions.ImportPupitriMelagWeightPopupValidateAction.class);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToImportPupitriMelagWeightDialog();
        addChildrenToMainPanel();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        melagWeightLabel.setLabelFor(melagWeight);
        melagWeight.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        melagWeight.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        melagWeight.setNumberType(Float.class);
        melagWeight.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.validate.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("add"));
        // late initializer
        importPupitriMelagWeightDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("importPupitriMelagWeightDialog", importPupitriMelagWeightDialog);
        createModel();
        createMainPanel();
        createMessage();
        createMelagWeightLabel();
        createMelagWeight();
        createValidateButton();
        // inline creation of importPupitriMelagWeightDialog
        setName("importPupitriMelagWeightDialog");
        importPupitriMelagWeightDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("tutti.importPupitri.melagWeight.title"));
        setModal(true);
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MELAG_WEIGHT_NUMBER_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalMelagWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    melagWeight.setNumberValue(model.getTotalMelagWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalMelagWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MELAG_WEIGHT_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalMelagComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    melagWeight.setBean(model.getTotalMelagComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalMelagComputedOrNotWeight", this);
                }
            }
        });
    }

}