/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential.consumer;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.csv.SpeciesModel;
import fr.ifremer.tutti.service.referential.csv.SpeciesRow;
import java.nio.file.Path;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class CsvConsumerForTemporarySpecies
extends CsvComsumer<SpeciesRow, SpeciesModel> {
    private static final Log log = LogFactory.getLog(CsvConsumerForTemporarySpecies.class);

    public CsvConsumerForTemporarySpecies(Path file, char separator, boolean addReferenceTaxonId, boolean reportError) {
        super(file, SpeciesModel.forImport(separator, addReferenceTaxonId), reportError);
    }

    public void checkRow(ImportRow<SpeciesRow> row, PersistenceService persistenceService, DecoratorService decoratorService, ReferentialImportRequest<Species, Integer> requestResult) {
        if (row.isValid()) {
            SpeciesRow bean = (SpeciesRow)row.getBean();
            Integer id = bean.getIdAsInt();
            boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
            if (id == null) {
                this.checkAdd(bean, requestResult);
            } else {
                Species species = requestResult.getExistingEntityById(id);
                if (species == null) {
                    throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.notExistingId", (Object[])new Object[]{id}));
                }
                if (delete) {
                    this.checkDelete(bean, species, persistenceService, decoratorService, requestResult);
                } else {
                    this.checkUpdate(bean, species, requestResult);
                }
            }
        }
        this.reportError(row);
    }

    public void checkRowForGenericFormatImport(ImportRow<SpeciesRow> row, ReferentialImportRequest<Species, Integer> requestResult) {
        SpeciesRow bean = (SpeciesRow)row.getBean();
        String name = bean.getName();
        if (row.isValid()) {
            Integer id = bean.getIdAsInt();
            if (id == null) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.noId", (Object[])new Object[0]))));
            } else if (!Speciess.isTemporaryId((Integer)id)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.idNotTemporary", (Object[])new Object[]{id}))));
            } else if (requestResult.isIdAlreadyAdded(id)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.id.alreaydAdded", (Object[])new Object[]{id}))));
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.noName", (Object[])new Object[0]))));
            } else if (requestResult.isNaturalIdAlreadyAdded(name)) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.name.alreaydAdded", (Object[])new Object[]{name}))));
            }
            if (bean.getReferenceTaxonId() == null) {
                this.addCheckError(row, (Exception)((Object)new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.noReferencetTaxonId", (Object[])new Object[0]))));
            }
        }
        this.reportError(row);
        if (row.isValid()) {
            Species entity = bean.toEntity(null);
            boolean toAdd = requestResult.addExistingNaturalId(name);
            if (toAdd) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will add species with name: " + name));
                }
                requestResult.addEntityToAdd(entity);
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will link species with name: " + name));
                }
                requestResult.addEntityToLink(entity);
            }
        }
    }

    protected void checkAdd(SpeciesRow bean, ReferentialImportRequest<Species, Integer> requestResult) {
        String name = bean.getName();
        boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
        if (delete) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.cannotDeleteWithoutId", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.noName", (Object[])new Object[0]));
        }
        if (!requestResult.addExistingNaturalId(name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.existingName", (Object[])new Object[]{name}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will add species with name: " + name));
        }
        requestResult.addEntityToAdd(bean.toEntity(null));
    }

    protected void checkDelete(SpeciesRow bean, Species species, PersistenceService persistenceService, DecoratorService decoratorService, ReferentialImportRequest<Species, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = bean.getName();
        Integer referenceTaxonId = species.getReferenceTaxonId();
        if (persistenceService.isTemporarySpeciesUsed(referenceTaxonId)) {
            String speciesRef = id + " : " + decoratorService.getDecoratorByType(Species.class, "withSurveyCode").toString((Object)species);
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.used", (Object[])new Object[]{speciesRef}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete species with referenceTaxonId: " + referenceTaxonId));
        }
        requestResult.addIdToDelete(referenceTaxonId);
        requestResult.removeExistingNaturalId(name);
    }

    protected void checkUpdate(SpeciesRow bean, Species species, ReferentialImportRequest<Species, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = bean.getName();
        Integer referenceTaxonId = species.getReferenceTaxonId();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.noName", (Object[])new Object[]{id}));
        }
        if (!species.getName().equals(name) && !requestResult.addExistingNaturalId(name)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.referential.import.species.error.existingName", (Object[])new Object[]{name}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will update species with referenceTaxonId: " + referenceTaxonId));
        }
        requestResult.addEntityToUpdate(bean.toEntity(referenceTaxonId));
    }
}

