/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.validation.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.ui.swing.content.validation.tree.MessageTreeNode;
import fr.ifremer.tutti.ui.swing.content.validation.tree.TuttiMessageNodeSupport;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import jaxx.runtime.SwingUtil;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class CruiseTreeNode
extends TuttiMessageNodeSupport<Cruise> {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon CRUISE_ICON = SwingUtil.createActionIcon((String)"cruise");

    public CruiseTreeNode(Cruise cruise, NuitonValidatorResult validationResult) {
        super(cruise, CRUISE_ICON, null);
        this.setAllowsChildren(true);
        this.createChildren(validationResult);
    }

    public void createChildren(NuitonValidatorResult validationResult) {
        boolean withMessage = false;
        if (validationResult.hasFatalMessages()) {
            this.addMessages(NuitonValidatorScope.FATAL, validationResult.getMessagesForScope(NuitonValidatorScope.FATAL));
            withMessage = true;
        }
        if (validationResult.hasErrorMessagess()) {
            this.addMessages(NuitonValidatorScope.ERROR, validationResult.getMessagesForScope(NuitonValidatorScope.ERROR));
            withMessage = true;
        }
        if (validationResult.hasWarningMessages()) {
            this.addMessages(NuitonValidatorScope.WARNING, validationResult.getMessagesForScope(NuitonValidatorScope.WARNING));
            withMessage = true;
        }
        if (!withMessage) {
            this.addMessages(NuitonValidatorScope.INFO, Lists.newArrayList((Object[])new String[]{I18n.t((String)"tutti.validator.info.cruise.noError", (Object[])new Object[0])}));
        }
    }

    protected void addMessages(NuitonValidatorScope scope, List<String> messages) {
        HashSet messageSet = Sets.newHashSet(messages);
        for (String message : messageSet) {
            MessageTreeNode child = new MessageTreeNode(scope, message, null);
            this.add(child);
        }
    }
}

