// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringDao.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.andromda.spring.PaginationResult;

/**
 * Il désigne un ensemble de taxons appartenant à des groupes taxinomiques différents mais ayant les
 * mêmes caractéristiques pour un critère donné. Ce critère peut être morpho-anatomique (par exemple
 * les strates algales ou la taille des organismes), comportemental (par exemple des groupes
 * trophiques ou des modes de déplacement), ou encore basé sur des notions plus complexes comme la
 * polluo-sensibilité (exemple des groupes écologiques définis pour les macroinvertébrés
 * benthiques). Pour un critère donné, les groupes de taxons sont rassemblés dans un regroupement
 * appelé groupe de taxons père.
 * Les groupes de taxons sont de deux catégories :
 * - Descriptif : c'est à dire seulement utilisé pour l'extraction de données. Les regroupements de
 * taxons sont effectués en aval de la mesure effectuée.
 * - Identification : il s'agit de regroupements utilisés pour identifier des catégories de taxons
 * sur le terrain ou en laboratoire, lorsqu'il est difficile d'opérer une identification précise ou
 * lorsque celle-ci s'avère tout simplement impossible ou non pertinente. Le regroupement des taxons
 * s'effectue alors en amont de la mesure.
 * Certains groupes peuvent être figés, c'est à dire qu'ils sont définis une bonne fois pour toute
 * dans un document. Pour ce dernier cas particulier, il n'y a donc, a priori, pas besoin de mise à
 * jour, et encore moins de pouvoir les supprimer : ils sont donc non modifiables (mais ce ne doit
 * pas être une règle générale)
 * @see TaxonGroup
 */
public interface TaxonGroupDao
{
    /**
     * This constant is used as a transformation flag; entities can be converted automatically into value objects
     * or other types, different methods in a class implementing this interface support this feature: look for
     * an <code>int</code> parameter called <code>transform</code>.
     * <p>
     * This specific flag denotes no transformation will occur.
     */
    public static final int TRANSFORM_NONE = 0;


    /**
     * Transforms the given results to a collection of {@link TaxonGroup}
     * instances (this is useful when the returned results contains a row of data and you want just entities only).
     *
     * @param results the query results.
     */
    public void toEntities(final Collection<?> results);

    /**
     * Gets an instance of TaxonGroup from the persistent store.
     * @param id
     * @return TaxonGroup
     */
    public TaxonGroup get(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #get(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to get.
     * @return either the entity or the object transformed from the entity.
     */
    public Object get(int transform, Integer id);

    /**
     * Loads an instance of TaxonGroup from the persistent store.
     * @param id
     * @return TaxonGroup
     */
    public TaxonGroup load(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #load(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to load.
     * @return either the entity or the object transformed from the entity.
     */
    public Object load(int transform, Integer id);

    /**
     * Loads all entities of type {@link TaxonGroup}.
     *
     * @return the loaded entities.
     */
    public Collection<TaxonGroup> loadAll();

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform);

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int pageNumber, final int pageSize);

    /**
     * <p>
     * Does the same thing as {@link #loadAll(int)} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform, final int pageNumber, final int pageSize);

    /**
     * Creates an instance of TaxonGroup and adds it to the persistent store.
     * @param taxonGroup
     * @return TaxonGroup
     */
    public TaxonGroup create(TaxonGroup taxonGroup);

    /**
     * <p>
     * Does the same thing as {@link #create(TaxonGroup)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param taxonGroup
     * @return Object
     */
    public Object create(int transform, TaxonGroup taxonGroup);

    /**
     * Creates a new instance of TaxonGroup and adds
     * from the passed in <code>entities</code> collection
     *
     * @param entities the collection of TaxonGroup
     * instances to create.
     *
     * @return the created instances.
     */
    public Collection<TaxonGroup> create(Collection<TaxonGroup> entities);

    /**
     * <p>
     * Does the same thing as {@link #create(TaxonGroup)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param entities
     * @return Collection
     */
    public Collection<?> create(int transform, Collection<TaxonGroup> entities);

    /**
     * <p>
     * Creates a new <code>TaxonGroup</code>
     * instance from <strong>all</strong> attributes and adds it to
     * the persistent store.
     * </p>
     * @param label Code (ou mnénomique) du groupe de taxons. Ceci peut être un code de quelques caractères identifiant
le groupe. (exemple: Ca pour carnivores)
     * @param name Nom du groupe de taxons.
     * @param comments Commentaire long associé au groupe de taxons.
     * @param isChildGroupExclusive Ce champ permet de renseigner si les groupes de taxons fils sont exclusifs ou pas. Par défaut, les
fils ne sont pas exclusifs. S'ils sont exclusifs, un même taxon ne pourra pas faire parti de
plusieurs groupes du même taxon père.
     * @param isUpdatable Cette information permet de savoir si un groupe de taxons est modifiable ou pas dans l'interface de
mise à jour.
     * @param creationDate Date de création système du groupe. Renseigné automatiquement par le système.
     * @param updateDate Date de mise à jour système du groupe. Renseigné automatiquement par le système.
     * @return TaxonGroup
     */
    public TaxonGroup create(
        String label,
        String name,
        String comments,
        Boolean isChildGroupExclusive,
        Boolean isUpdatable,
        Date creationDate,
        Timestamp updateDate);

    /**
     * <p>
     * Does the same thing as {@link #create(String, String, String, Boolean, Boolean, Date, Timestamp)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param label Code (ou mnénomique) du groupe de taxons. Ceci peut être un code de quelques caractères identifiant
le groupe. (exemple: Ca pour carnivores)
     * @param name Nom du groupe de taxons.
     * @param comments Commentaire long associé au groupe de taxons.
     * @param isChildGroupExclusive Ce champ permet de renseigner si les groupes de taxons fils sont exclusifs ou pas. Par défaut, les
fils ne sont pas exclusifs. S'ils sont exclusifs, un même taxon ne pourra pas faire parti de
plusieurs groupes du même taxon père.
     * @param isUpdatable Cette information permet de savoir si un groupe de taxons est modifiable ou pas dans l'interface de
mise à jour.
     * @param creationDate Date de création système du groupe. Renseigné automatiquement par le système.
     * @param updateDate Date de mise à jour système du groupe. Renseigné automatiquement par le système.
     * @return TaxonGroup
     */
    public Object create(
        int transform,
        String label,
        String name,
        String comments,
        Boolean isChildGroupExclusive,
        Boolean isUpdatable,
        Date creationDate,
        Timestamp updateDate);

    /**
     * <p>
     * Creates a new <code>TaxonGroup</code>
     * instance from only <strong>required</strong> properties (attributes
     * and association ends) and adds it to the persistent store.
     * </p>
     * @param creationDate
     * @param isChildGroupExclusive
     * @param isUpdatable
     * @param name
     * @param status
     * @param taxonGroupType
     * @return TaxonGroup
     */
    public TaxonGroup create(
        Date creationDate,
        Boolean isChildGroupExclusive,
        Boolean isUpdatable,
        String name,
        Status status,
        TaxonGroupType taxonGroupType);

    /**
     * <p>
     * Does the same thing as {@link #create(String, Boolean, Boolean, Date)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform flag to determine transformation type.
     * @param creationDate
     * @param isChildGroupExclusive
     * @param isUpdatable
     * @param name
     * @param status
     * @param taxonGroupType
     * @return Object
     */
    public Object create(
        int transform,
        Date creationDate,
        Boolean isChildGroupExclusive,
        Boolean isUpdatable,
        String name,
        Status status,
        TaxonGroupType taxonGroupType);

    /**
     * Updates the <code>taxonGroup</code> instance in the persistent store.
     * @param taxonGroup
     */
    public void update(TaxonGroup taxonGroup);

    /**
     * Updates all instances in the <code>entities</code> collection in the persistent store.
     * @param entities
     */
    public void update(Collection<TaxonGroup> entities);

    /**
     * Removes the instance of TaxonGroup from the persistent store.
     * @param taxonGroup
     */
    public void remove(TaxonGroup taxonGroup);

    /**
     * Removes the instance of TaxonGroup having the given
     * <code>identifier</code> from the persistent store.
     * @param id
     */
    public void remove(Integer id);

    /**
     * Removes all entities in the given <code>entities</code> collection.
     * @param entities
     */
    public void remove(Collection<TaxonGroup> entities);


    /**
     * Does the same thing as {@link #search(int, Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param transform the transformation flag.
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int transform, final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * finder results will <strong>NOT</strong> be transformed during retrieval.
     * If this flag is any of the other constants defined here
     * then results <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     *
     * @param transform the transformation flag.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<?> search(final int transform, final Search search);

    /**
     * Performs a search using the parameters specified in the given <code>search</code> object.
     *
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<TaxonGroup> search(final Search search);

    /**
     * Allows transformation of entities into value objects
     * (or something else for that matter), when the <code>transform</code>
     * flag is set to one of the constants defined in <code>fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupDao</code>, please note
     * that the {@link #TRANSFORM_NONE} constant denotes no transformation, so the entity itself
     * will be returned.
     *
     * If the integer argument value is unknown {@link #TRANSFORM_NONE} is assumed.
     *
     * @param transform one of the constants declared in {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupDao}
     * @param entity an entity that was found
     * @return the transformed entity (i.e. new value object, etc)
     * @see #transformEntities(int,Collection)
     */
    public Object transformEntity(final int transform, final TaxonGroup entity);

    /**
     * Transforms a collection of entities using the
     * {@link #transformEntity(int,TaxonGroup)}
     * method. This method does not instantiate a new collection.
     * <p>
     * This method is to be used internally only.
     *
     * @param transform one of the constants declared in <code>fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupDao</code>
     * @param entities the collection of entities to transform
     * @see #transformEntity(int,TaxonGroup)
     */
    public void transformEntities(final int transform, final Collection<?> entities);

    // spring-dao merge-point
}