// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.pmfm;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Niveau (ou période) d'agrégation de la donnée.
 * Par exemple :
 * - aucune (pas d'agrégation)
 * - jour,
 * - mois,
 * - année
 * - marée
 * - opération
 * - zone de peche (cas des séquences de peche ?)
 * Utiliser une période d'agrégation permet de définir des valeurs moyennes sur une période
 * d'agrégation (par exemple : le mois) indépendamment de la période concernée (par exemple : une
 * année).
 * Exemple :
 * - moyenne mensuelle sur l'année, du nombre d'engin levé par jour :
 * - paramètre : nombre d'engin levé
 * - niveau d'agrégation du PSFM : jour
 * - période concerné : 01/01/XX au 31/12/XX : définie au niveau de l'entité à laquelle est
 * rattachée la mesure (exemple : la marée, l'opération, les caractéristiques d'utilisation, etc.).
 * - période d'agrégation sur la mesure (xxxMeasurement) : mois
 */
// HibernateEntity.vsl annotations merge-point
public abstract class AggregationLevel
    implements Serializable, Comparable<AggregationLevel>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -5347810867364996451L;

    // Generate 4 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private Integer rankOrder;

    /**
     * rang permettant de classer les niveau d'agrégation par ordre de précision : le niveau le plus
     * bas est 'aucune' (donnée brute), le niveau le plus haut pourrait etre 'année' (moyenne
     * annuelle)
     * @return this.rankOrder Integer
     */
    public Integer getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * rang permettant de classer les niveau d'agrégation par ordre de précision : le niveau le plus
     * bas est 'aucune' (donnée brute), le niveau le plus haut pourrait etre 'année' (moyenne
     * annuelle)
     * @param rankOrderIn Integer
     */
    public void setRankOrder(Integer rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 2 associations
    /**
     * Returns <code>true</code> if the argument is an AggregationLevel instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof AggregationLevel))
        {
            return false;
        }
        final AggregationLevel that = (AggregationLevel)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link AggregationLevel}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link AggregationLevel}.
         * @return new AggregationLevelImpl()
         */
        public static AggregationLevel newInstance()
        {
            return new AggregationLevelImpl();
        }

        /**
         * Constructs a new instance of {@link AggregationLevel}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param rankOrder Integer
         * @return newInstance
         */
        public static AggregationLevel newInstance(String name, Integer rankOrder)
        {
            final AggregationLevel entity = new AggregationLevelImpl();
            entity.setName(name);
            entity.setRankOrder(rankOrder);
            return entity;
        }

        /**
         * Constructs a new instance of {@link AggregationLevel}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param rankOrder Integer
         * @param updateDate Timestamp
         * @return newInstance AggregationLevel
         */
        public static AggregationLevel newInstance(String name, Integer rankOrder, Timestamp updateDate)
        {
            final AggregationLevel entity = new AggregationLevelImpl();
            entity.setName(name);
            entity.setRankOrder(rankOrder);
            entity.setUpdateDate(updateDate);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(AggregationLevel o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// AggregationLevel.java merge-point
}