/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.i18n.I18n;

public class EnumByNameParserFormatter<E extends Enum<E>>
implements ValueParserFormatter<E> {
    private final Class<E> enumType;
    private final boolean mandatory;

    public EnumByNameParserFormatter(Class<E> enumType, boolean mandatory) {
        this.enumType = enumType;
        this.mandatory = mandatory;
    }

    public E parse(String value) throws ParseException {
        E result = StringUtils.isBlank((CharSequence)value) ? null : (E)Enum.valueOf(this.enumType, value);
        if (this.mandatory && result == null) {
            throw new NullPointerException(I18n.t((String)"tutti.service.cvs.mandatory.value", (Object[])new Object[0]));
        }
        return result;
    }

    public String format(E date) {
        String value = "";
        if (date != null) {
            value = ((Enum)date).name();
        }
        return value;
    }
}

