/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolSpeciesAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ImportProtocolSpeciesAction.class);
    private File file;

    public ImportProtocolSpeciesAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(I18n.t((String)"tutti.editProtocol.title.choose.speciesImportFile", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.action.importProtocolSpeciesFile", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        String message;
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol species file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiProtocol protocol = (TuttiProtocol)model.toBean();
        ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        List notImportedSpecies = service.importProtocolSpecies(this.file, protocol, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        List<EditProtocolSpeciesRowModel> rows = ((EditProtocolUIHandler)this.handler).toSpeciesRows(protocol.getSpecies());
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().getHandler().reset();
        ((EditProtocolUI)this.getUI()).getBenthosComboBox().getHandler().reset();
        model.setSpeciesRow(rows);
        ((EditProtocolUIHandler)this.getHandler()).getSpeciesTableModel().setRows(rows);
        int nbSynonym = 0;
        for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
            if (speciesProtocol.isMadeFromAReferentTaxon()) continue;
            ++nbSynonym;
        }
        switch (nbSynonym) {
            case 0: {
                message = I18n.t((String)"tutti.flash.info.species.imported.in.protocol", (Object[])new Object[]{this.file});
                break;
            }
            case 1: {
                message = I18n.t((String)"tutti.flash.info.species.imported.in.protocol.oneReplaced", (Object[])new Object[]{this.file});
                break;
            }
            default: {
                message = I18n.t((String)"tutti.flash.info.species.imported.in.protocol.severalReplaced", (Object[])new Object[]{this.file, nbSynonym});
            }
        }
        this.sendMessage(message);
        if (!notImportedSpecies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Species sp : notImportedSpecies) {
                sb.append("<li>" + this.decorate(sp, "fromProtocol") + "</li>");
            }
            this.displayWarningMessage(I18n.t((String)"tutti.editProtocol.action.importProtocolSpecies.speciesInBenthos.title", (Object[])new Object[0]), "<html><body>" + I18n.t((String)"tutti.editProtocol.action.importProtocolSpecies.speciesInBenthos", (Object[])new Object[]{sb.toString()}) + "</body></html>");
        }
    }
}

