/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.CharType;

@DataTypeInfo(name="nvarchar", aliases={"java.sql.Types.NVARCHAR", "nvarchar2"}, minParameters=0, maxParameters=1, priority=1)
public class NVarcharType
extends CharType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof HsqlDatabase || database instanceof PostgresDatabase || database instanceof DerbyDatabase) {
            return new DatabaseDataType("VARCHAR", this.getParameters());
        }
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("NVARCHAR2", this.getParameters());
        }
        if (database instanceof MSSQLDatabase) {
            Object param1;
            if (this.getParameters() != null && this.getParameters().length > 0 && (param1 = this.getParameters()[0]).toString().matches("\\d+") && Long.valueOf(param1.toString()) > 8000L) {
                return new DatabaseDataType("NVARCHAR", "MAX");
            }
            return new DatabaseDataType("NVARCHAR", this.getParameters());
        }
        return super.toDatabaseDataType(database);
    }
}

