/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.elements.strategy.ExtendedItemPropSearchStrategy;
import org.eclipse.birt.report.model.elements.strategy.GroupPropSearchStrategy;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;

class PropertyHandleHelperImpl {
    PropertyHandleHelperImpl() {
    }

    public boolean isReadOnlyInContext(PropertyHandle propHandle) {
        DesignElementHandle element = propHandle.getElementHandle();
        Module module = propHandle.getModule();
        String propName = propHandle.getPropertyDefn().getName();
        if (element instanceof MasterPageHandle) {
            MasterPage masterPage = (MasterPage)element.getElement();
            if (!masterPage.isCustomType(module) && ("height".equals(propName) || "width".equals(propName))) {
                return true;
            }
        } else {
            if (element instanceof GroupHandle) {
                DesignElementHandle tmpContainer = element.getContainer();
                if (tmpContainer == null) {
                    return false;
                }
                return GroupPropSearchStrategy.getDataBindingPropties().contains(propName) && ((ListingElement)tmpContainer.getElement()).isDataBindingReferring(module);
            }
            if (element instanceof ReportItemHandle) {
                boolean retValue;
                boolean containsProp = ReportItemPropSearchStrategy.isDataBindingProperty(element.getElement(), propName);
                boolean bl = retValue = containsProp && ((ReportItem)element.getElement()).isDataBindingReferring(module);
                if (retValue) {
                    return true;
                }
                if (!containsProp) {
                    containsProp = ExtendedItemPropSearchStrategy.isHostViewProperty(element.getElement(), propName);
                }
                if (element instanceof ExtendedItemHandle) {
                    return containsProp && element.getContainer() instanceof MultiViewsHandle;
                }
            } else {
                TabularDimension dimension;
                if (element instanceof RowHandle && "repeatable".equals(propName)) {
                    return !this.rowRepeatableVisibleInContext(element);
                }
                if (element instanceof TabularDimensionHandle && (dimension = (TabularDimension)element.getElement()).hasSharedDimension(element.getModule())) {
                    return true;
                }
            }
        }
        DesignElementHandle container = element.getContainer();
        while (container != null) {
            TabularDimension dimension;
            if (container instanceof TabularDimensionHandle && (dimension = (TabularDimension)container.getElement()).hasSharedDimension(container.getModule())) {
                return true;
            }
            container = container.getContainer();
        }
        return false;
    }

    private boolean rowRepeatableVisibleInContext(DesignElementHandle handle) {
        assert (handle instanceof RowHandle);
        boolean isVisible = false;
        DesignElementHandle container = handle.getContainer();
        if (container instanceof TableHandle) {
            int containerSlotID = handle.getContainerSlotHandle().getSlotID();
            if (containerSlotID == 0 || 3 == containerSlotID) {
                isVisible = true;
            }
        } else if (container instanceof TableGroupHandle) {
            isVisible = true;
        }
        return isVisible;
    }

    public boolean isVisibleInContext(PropertyHandle propHandle) {
        boolean isVisible = true;
        DesignElementHandle element = propHandle.getElementHandle();
        String propName = propHandle.getPropertyDefn().getName();
        if (element instanceof RowHandle && "repeatable".equals(propName)) {
            isVisible = this.rowRepeatableVisibleInContext(element);
        }
        return isVisible;
    }
}

