/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import org.eclipse.birt.core.data.IDimLevel;

class DimLevel
implements IDimLevel {
    private String dimensionName;
    private String levelName;
    private String attrName;
    private String qualifiedName;

    public DimLevel(String dimensionName, String levelName) {
        this(dimensionName, levelName, null);
    }

    public DimLevel(String dimensionName, String levelName, String attrName) {
        this.dimensionName = dimensionName;
        this.levelName = levelName;
        this.attrName = attrName;
        this.setQualifiedName();
    }

    private void setQualifiedName() {
        this.qualifiedName = this.getAttrReference(this.dimensionName, this.levelName, this.attrName == null ? this.levelName : this.attrName);
    }

    private String getAttrReference(String dimName, String levelName, String attrName) {
        return String.valueOf(dimName) + '/' + levelName + '/' + attrName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public String getLevelName() {
        return this.levelName;
    }

    @Override
    public String getAttrName() {
        return this.attrName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dimensionName == null ? 0 : this.dimensionName.hashCode());
        result = 31 * result + (this.levelName == null ? 0 : this.levelName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimLevel)) {
            return false;
        }
        DimLevel other = (DimLevel)obj;
        if (this.dimensionName == null ? other.dimensionName != null : !this.dimensionName.equals(other.dimensionName)) {
            return false;
        }
        return !(this.levelName == null ? other.levelName != null : !this.levelName.equals(other.levelName));
    }

    public String toString() {
        return this.qualifiedName;
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof DimLevel)) {
            return -1;
        }
        DimLevel dimLevel = (DimLevel)obj;
        return this.toString().compareTo(dimLevel.toString());
    }
}

