/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.test;

import fr.ifremer.tutti.persistence.test.DatabaseResource;
import fr.ifremer.tutti.persistence.test.TuttiRunListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runners.model.Statement;

public class CleanResourcesRule
implements TestRule {
    private static final Log log = LogFactory.getLog(CleanResourcesRule.class);
    private static final Map<Description, DatabaseResource> RESSOURCES_BY_DESCRIPTIONS = new HashMap<Description, DatabaseResource>();

    public static void registerDescription(Description description, DatabaseResource databaseResource) {
        RESSOURCES_BY_DESCRIPTIONS.put(description, databaseResource);
    }

    public static void cleanResources(Description description) {
        DatabaseResource databaseResource = RESSOURCES_BY_DESCRIPTIONS.get(description);
        if (databaseResource != null) {
            Failure failure;
            if (log.isInfoEnabled()) {
                log.info((Object)("Try to clean resources for test: " + description));
            }
            if ((failure = TuttiRunListener.getFailureForDescription(description)) == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Clean resources (no failure found) for test: " + description));
                }
                databaseResource.cleanResources(description);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Keep resources ((found failure) for test: " + description));
            }
        }
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    CleanResourcesRule.this.after(description);
                }
            }
        };
    }

    protected void after(Description description) {
        CleanResourcesRule.cleanResources(description);
        for (Description childDescription : description.getChildren()) {
            CleanResourcesRule.cleanResources(childDescription);
        }
    }
}

