/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TuttiEntities {
    public static final Function<TuttiEntity, String> GET_ID = new Function<TuttiEntity, String>(){

        public String apply(TuttiEntity input) {
            return input.getId();
        }
    };
    public static final Function<TuttiEntity, Integer> GET_ID_AS_INT = new Function<TuttiEntity, Integer>(){

        public Integer apply(TuttiEntity input) {
            return input.getIdAsInt();
        }
    };

    protected TuttiEntities() {
    }

    public static <B extends TuttiEntity> List<String> toIds(Collection<B> list) {
        List result = list == null ? Collections.emptyList() : Lists.transform((List)(list instanceof List ? (List<Object>)list : new ArrayList<B>(list)), GET_ID);
        return result;
    }

    public static <B extends TuttiEntity> List<Integer> toIntegerIds(Collection<B> list) {
        List result = list == null ? Collections.emptyList() : Lists.transform((List)Lists.newArrayList(list), GET_ID_AS_INT);
        return result;
    }

    public static <B extends TuttiEntity> Map<String, B> splitById(Iterable<B> list) {
        return Maps.uniqueIndex(list, GET_ID);
    }

    public static <B extends TuttiEntity> Map<Integer, B> splitByIdAsInt(Iterable<B> list) {
        return Maps.uniqueIndex(list, GET_ID_AS_INT);
    }

    public static <B extends TuttiEntity> boolean isNew(B bean) {
        return bean.getId() == null;
    }

    public static <E extends TuttiEntity> Function<E, String> newIdFunction() {
        return GET_ID;
    }

    public static <E extends TuttiEntity> Function<E, Integer> newIdAstIntFunction() {
        return GET_ID_AS_INT;
    }

    public static <B extends TuttiEntity> Predicate<B> newIdPredicate(String id) {
        return new IdPredicate(id);
    }

    public static <B extends TuttiEntity> B findById(Iterable<B> beans, String id) {
        TuttiEntity result = (TuttiEntity)Iterables.tryFind(beans, TuttiEntities.newIdPredicate(id)).orNull();
        return (B)result;
    }

    public static <B extends TuttiEntity> List<String> collecIds(List<B> list) {
        List result = Lists.transform(list, GET_ID);
        return result;
    }

    protected static class IdPredicate<B extends TuttiEntity>
    implements Predicate<B> {
        private final String id;

        public IdPredicate(String id) {
            this.id = id;
        }

        public boolean apply(B input) {
            return this.id.equals(input.getId());
        }
    }
}

