/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.CmapIndexEntry;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class CmapTable
implements Table {
    private int version;
    private int numTables;
    private CmapIndexEntry[] entries;
    private CmapFormat[] formats;

    protected CmapTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        long l = randomAccessFile.getFilePointer();
        this.version = randomAccessFile.readUnsignedShort();
        this.numTables = randomAccessFile.readUnsignedShort();
        this.entries = new CmapIndexEntry[this.numTables];
        this.formats = new CmapFormat[this.numTables];
        int n = 0;
        while (n < this.numTables) {
            this.entries[n] = new CmapIndexEntry(randomAccessFile);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numTables) {
            randomAccessFile.seek(l + (long)this.entries[n2].getOffset());
            int n3 = randomAccessFile.readUnsignedShort();
            this.formats[n2] = CmapFormat.create(n3, randomAccessFile);
            ++n2;
        }
    }

    public CmapFormat getCmapFormat(short s, short s2) {
        int n = 0;
        while (n < this.numTables) {
            if (this.entries[n].getPlatformId() == s && this.entries[n].getEncodingId() == s2) {
                return this.formats[n];
            }
            ++n;
        }
        return null;
    }

    public int getType() {
        return 1668112752;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("cmap\n");
        int n = 0;
        while (n < this.numTables) {
            stringBuffer.append("\t").append(this.entries[n].toString()).append("\n");
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numTables) {
            stringBuffer.append("\t").append(this.formats[n2].toString()).append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

