/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Component;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JTabbedPane;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.tab.CustomTab;
import org.nuiton.jaxx.application.swing.tab.DelegateTabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.application.swing.tab.TabHandler;

public abstract class AbstractTuttiTabContainerUIHandler<M, UI extends TuttiUI<M, ?>>
extends AbstractTuttiUIHandler<M, UI>
implements TabContainerHandler {
    DelegateTabContainerHandler delegateTabHandler;

    public TabHandler getTabHandler(int index) {
        ApplicationUI tuttiTab;
        AbstractApplicationUIHandler handler;
        Component tab;
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = this.getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount() && ApplicationUI.class.isInstance(tab = tabPanel.getComponentAt(index)) && TabHandler.class.isInstance(handler = (tuttiTab = (ApplicationUI)tabPanel.getComponentAt(index)).getHandler())) {
            tabHandler = (TabHandler)handler;
        }
        return tabHandler;
    }

    public void setCustomTab(int index, TabContentModel model) {
        JTabbedPane tabPanel = this.getTabPanel();
        tabPanel.setTabComponentAt(index, (Component)new CustomTab(model, (TabContainerHandler)this));
    }

    protected void initUI(UI ui) {
        super.initUI(ui);
        this.delegateTabHandler = new DelegateTabContainerHandler(this.getTabPanel());
        this.init();
    }

    public void init() {
        this.getTabPanel().setModel(new DefaultSingleSelectionModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = AbstractTuttiTabContainerUIHandler.this.getTabPanel().getSelectedIndex();
                boolean mustChangeTab = AbstractTuttiTabContainerUIHandler.this.onTabChanged(currentIndex, index);
                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
            }
        });
    }

    public boolean onTabChanged(int currentIndex, int newIndex) {
        boolean result = true;
        if (currentIndex != newIndex) {
            TabHandler handler = this.getTabHandler(currentIndex);
            if (handler != null) {
                result = handler.onHideTab(currentIndex, newIndex);
            }
            if ((handler = this.getTabHandler(newIndex)) != null) {
                handler.onShowTab(currentIndex, newIndex);
            }
        }
        return result;
    }
}

