/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.cache.BasicCachedArray;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.RowSaveUtil;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.viewing.IDataSetResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.RowIndexUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

class ExprDataReader2
implements IExprDataReader {
    private int version;
    private RAInputStream rowExprsIs;
    private RAInputStream rowLenIs;
    private DataInputStream rowExprsDis;
    private DataInputStream rowLenDis;
    protected int rowCount;
    private int lastRowIndex;
    private int currRowIndex;
    private int currRowLenReadIndex;
    private RowIndexUtil rowIndexUtil;
    private int nextDestIndex;
    private Map exprValueMap;
    private BasicCachedArray rowIDMap;
    private List exprKeys;
    private int metaOffset;
    private Map dataSetExprKeys;
    private IDataSetResultSet dataSetResultSet;
    private Map bindingNameTypeMap;
    private ClassLoader currentClassLoader;

    ExprDataReader2(String tempDir, RAInputStream rowExprsIs, RAInputStream rowLenIs, RAInputStream rowInfoIs, int version, IDataSetResultSet dataSetResultSet) throws DataException {
        this.version = version;
        this.rowIndexUtil = new RowIndexUtil(rowInfoIs);
        try {
            int rowCount = (int)(rowInfoIs.length() / 4L);
            this.initialize(tempDir, rowExprsIs, rowLenIs, rowCount, dataSetResultSet);
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"Result Data");
        }
    }

    private void initialize(String tempDir, RAInputStream rowExprsIs, RAInputStream rowLenIs, int rowCount, IDataSetResultSet dataSetResultSet) throws DataException {
        try {
            this.currentClassLoader = DataEngineSession.getCurrentClassLoader();
            IOUtil.readInt(rowExprsIs);
            int exprCount = IOUtil.readInt(rowExprsIs);
            this.exprKeys = new ArrayList();
            this.dataSetExprKeys = new HashMap();
            this.rowExprsDis = new DataInputStream(rowExprsIs);
            this.rowLenDis = new DataInputStream(rowLenIs);
            this.bindingNameTypeMap = new HashMap();
            int i = 0;
            while (i < exprCount) {
                String key = IOUtil.readString(this.rowExprsDis);
                this.exprKeys.add(key);
                if (this.version >= 50) {
                    this.bindingNameTypeMap.put(key, IOUtil.readInt(this.rowExprsDis));
                }
                ++i;
            }
            if (this.version >= 50) {
                int dataSetColumnExprCount = IOUtil.readInt(this.rowExprsDis);
                int i2 = 0;
                while (i2 < dataSetColumnExprCount) {
                    String key = IOUtil.readObject(this.rowExprsDis, this.currentClassLoader).toString();
                    this.dataSetExprKeys.put(key, IOUtil.readObject(this.rowExprsDis, this.currentClassLoader));
                    this.bindingNameTypeMap.put(key, IOUtil.readInt(this.rowExprsDis));
                    ++i2;
                }
            }
            if (this.dataSetExprKeys.size() > 0) {
                this.dataSetResultSet = dataSetResultSet;
            }
            this.metaOffset = 4 + IOUtil.readInt(this.rowExprsDis) + 4;
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"Result Data");
        }
        this.rowExprsIs = rowExprsIs;
        this.rowLenIs = rowLenIs;
        this.currRowIndex = -1;
        this.lastRowIndex = -1;
        this.currRowLenReadIndex = 0;
        this.rowCount = rowCount;
        this.rowIDMap = new BasicCachedArray(tempDir, rowCount);
    }

    @Override
    public int getCount() {
        return this.rowCount;
    }

    @Override
    public int getRowId() {
        int destIndex = (Integer)this.rowIDMap.get(this.currRowIndex);
        return destIndex;
    }

    @Override
    public int getRowIndex() {
        if (this.currRowIndex >= this.rowCount) {
            return this.rowCount;
        }
        return this.currRowIndex;
    }

    @Override
    public boolean next() {
        boolean hasNext;
        ++this.currRowIndex;
        boolean bl = hasNext = this.currRowIndex < this.rowCount;
        if (hasNext) {
            this.nextDestIndex = this.getNextDestIndex(this.currRowIndex);
            this.rowIDMap.set(this.currRowIndex, this.nextDestIndex);
        }
        return hasNext;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void moveTo(int index) throws DataException {
        if (index < 0 || index >= this.rowCount) {
            throw new DataException("data.engine.invalidRowIndex", index);
        }
        if (index < this.currRowIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (index != this.currRowIndex) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            this.next();
lbl9:
            // 2 sources

            ** while (this.currRowIndex < index)
        }
lbl10:
        // 1 sources

    }

    protected int getNextDestIndex(int currIndex) {
        return this.rowIndexUtil.read();
    }

    @Override
    public Map getRowValue() throws DataException {
        try {
            if (this.rowCount == 0) {
                if (this.exprValueMap == null) {
                    this.exprValueMap = this.getValueMap();
                }
            } else {
                if (this.lastRowIndex == this.currRowIndex) {
                    return this.exprValueMap;
                }
                this.lastRowIndex = this.currRowIndex;
                this.skipTo(this.nextDestIndex);
                this.exprValueMap = this.getValueMap();
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"Result Data");
        }
        return this.exprValueMap;
    }

    private void skipTo(int absoluteIndex) throws IOException, DataException {
        if (this.dataSetResultSet != null) {
            this.dataSetResultSet.skipTo(absoluteIndex);
        }
        if (this.currRowLenReadIndex == absoluteIndex) {
            return;
        }
        this.currRowLenReadIndex = absoluteIndex + 1;
        this.rowLenIs.seek((long)absoluteIndex * (this.version > 25 ? 8L : 4L));
        if (this.version <= 25) {
            this.rowExprsIs.seek(IOUtil.readInt(this.rowLenIs) + this.metaOffset);
        } else {
            this.rowExprsIs.seek(IOUtil.readLong(this.rowLenDis) + (long)this.metaOffset);
        }
        this.rowExprsDis = new DataInputStream(this.rowExprsIs);
    }

    private Map getValueMap() throws IOException, DataException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int exprCount = IOUtil.readInt(this.rowExprsDis);
        int i = 0;
        while (i < exprCount) {
            String exprID = this.exprKeys.get(i).toString();
            Object exprValue = IOUtil.readObject(this.rowExprsDis, this.currentClassLoader);
            if (RowSaveUtil.EXCEPTION_INDICATOR.equals(exprValue)) {
                valueMap.put(exprID, new DataException("data.engine.ReadColumnValueFromDocumentError", exprID));
            } else {
                valueMap.put(exprID, exprValue);
            }
            ++i;
        }
        Iterator it = this.dataSetExprKeys.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            String value = (String)this.dataSetExprKeys.get(key);
            IResultObject o = this.dataSetResultSet.getResultObject();
            try {
                valueMap.put(key, o == null ? null : DataTypeUtil.convert(o.getFieldValue(value), (Integer)this.bindingNameTypeMap.get(key)));
            }
            catch (BirtException e) {
                valueMap.put(key, e);
            }
        }
        return valueMap;
    }

    @Override
    public void close() {
        try {
            if (this.rowExprsDis != null) {
                this.rowExprsDis.close();
                this.rowExprsDis = null;
            }
        }
        catch (IOException iOException) {}
    }
}

