/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class Weights {
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat decimalFormat;

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (symbols == null) {
            symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
        }
        return symbols;
    }

    public static DecimalFormat getDecimalFormat(int minDecimal, int maxDecimal) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(Weights.getDecimalFormatSymbols());
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setMinimumFractionDigits(minDecimal);
        decimalFormat.setMaximumFractionDigits(maxDecimal);
        return decimalFormat;
    }

    public static String getWeightStringValue(Float weight) {
        String textValue;
        if (weight != null) {
            DecimalFormat weightDecimalFormat = Weights.getDecimalFormat(1, 3);
            textValue = weightDecimalFormat.format(weight);
        } else {
            textValue = "";
        }
        return textValue;
    }

    public static float roundKiloGram(float value) {
        BigDecimal sumB = new BigDecimal(String.valueOf(value)).setScale(3, 4).abs();
        float result = sumB.floatValue();
        return result;
    }

    public static int compareWeights(float v0, float v1) {
        v0 = Weights.roundKiloGram(v0);
        v1 = Weights.roundKiloGram(v1);
        return Weights.compareRawWeights(v0, v1);
    }

    public static int compareRawWeights(float v0, float v1) {
        float delta = v0 - v1;
        int result = (double)delta > 1.0E-5 ? 1 : (delta < -1.0E-4f ? -1 : 0);
        return result;
    }

    public static boolean isSmallerWeight(float v0, float v1) {
        return Weights.compareWeights(v0, v1) < 0;
    }

    public static boolean isGreaterWeight(float v0, float v1) {
        return Weights.compareWeights(v0, v1) > 0;
    }

    public static boolean isEqualWeight(float v0, float v1) {
        return Weights.compareWeights(v0, v1) == 0;
    }

    public static boolean isNotEqualWeight(float v0, float v1) {
        return Weights.compareWeights(v0, v1) != 0;
    }

    public static boolean isNullOrZero(Float weight) {
        return weight == null || Weights.compareRawWeights(weight.floatValue(), 0.0f) == 0;
    }
}

