/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.producer;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.csv.ParameterModel;
import fr.ifremer.tutti.service.genericformat.csv.ParameterRow;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CsvProducerForParameter
extends CsvProducer<ParameterRow, ParameterModel> {
    public CsvProducerForParameter(Path file, ParameterModel model) {
        super(file, model);
    }

    public List<ParameterRow> getDataToExport(Cruise cruise, FishingOperation operation) {
        CaracteristicMap vesselUseFeatures;
        ArrayList<ParameterRow> rows = new ArrayList<ParameterRow>();
        CaracteristicMap gearUseFeatures = operation.getGearUseFeatures();
        if (gearUseFeatures != null) {
            this.addCaracteristicMap(rows, cruise, operation, ParameterRow.ParameterType.GEAR, gearUseFeatures);
        }
        if ((vesselUseFeatures = operation.getVesselUseFeatures()) != null) {
            this.addCaracteristicMap(rows, cruise, operation, ParameterRow.ParameterType.VESSEL, vesselUseFeatures);
        }
        return rows;
    }

    protected void addCaracteristicMap(List<ParameterRow> rows, Cruise cruise, FishingOperation operation, ParameterRow.ParameterType parameterType, CaracteristicMap caracteristicMap) {
        for (Map.Entry entry : caracteristicMap.entrySet()) {
            ParameterRow row = new ParameterRow();
            row.setParameterType(parameterType);
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setCaracteristic((Caracteristic)entry.getKey());
            row.setValue((Serializable)entry.getValue());
            rows.add(row);
        }
    }
}

