package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 3/7/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.15
 */
public class OpenAddBenthosBatchSampleCategoryUIAction extends SimpleActionSupport<BenthosBatchUI> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(OpenAddBenthosBatchSampleCategoryUIAction.class);

    private static final long serialVersionUID = -6540241422935319461L;

    public OpenAddBenthosBatchSampleCategoryUIAction(BenthosBatchUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(BenthosBatchUI ui) {

        // get table model
        BenthosBatchTableModel tableModel = ui.getHandler().getTableModel();

        // get selected row
        int rowIndex = SwingUtil.getSelectedModelRow(ui.getTable());
        Preconditions.checkState(rowIndex != -1, "Cant split batch if no batch selected");

        // get selected column
        int columnIndex = SwingUtil.getSelectedModelColumn(ui.getTable());
        Preconditions.checkState(columnIndex != -1, "Cant split batch if no batch selected");

        // get selected row
        BenthosBatchRowModel selectedRow = tableModel.getEntry(rowIndex);

        // get his sample category
        Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);

        // get the first ancestor row using this category
        BenthosBatchRowModel firstAncestorRow = selectedRow.getFirstAncestor(sampleCategoryId);

        // get his parent (the one we will edit)
        BenthosBatchRowModel parentBatch = firstAncestorRow.getParentBatch();

        if (log.isDebugEnabled()) {
            log.debug("Open addChangeCategory batch ui for row [" + rowIndex + "] and category " + sampleCategoryId);
        }

        EditCatchesUI parentUI = ui.getParentContainer(EditCatchesUI.class);
        SplitBenthosBatchUI splitBatchEditor = parentUI.getBenthosTabAddSampleCategoryBatch();

//        parentUI.getHandler().addSampleCategoryBenthosBatch(parentBatch, splitBatchEditor, sampleCategoryId);


        splitBatchEditor.getHandler().editBatch(parentBatch, sampleCategoryId);

        // open split editor
        parentUI.getHandler().setBenthosSelectedCard(EditCatchesUIHandler.ADD_SAMPLE_CATEGORY_BATCH_CARD);

        // update title
        String title = parentUI.getHandler().buildReminderLabelTitle(parentBatch.getSpecies(),
                                                                     parentBatch,
                                                                     parentUI.getBenthosTabFishingOperationReminderLabel().getTitle(),
                                                                     t("tutti.addSampleCategoryBenthosBatch.title"));
        parentUI.getBenthosTabAddSampleCategoryBatchReminderLabel().setTitle(title);

    }
}
