/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.actions;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ImportMultiPostActionSupport;
import java.io.File;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class ImportMultiPostCatchAction
extends ImportMultiPostActionSupport<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    public ImportMultiPostCatchAction(EditCatchesUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiCatch";
    }

    @Override
    protected String getFileExtensionDescription() {
        return I18n.t((String)"tutti.common.file.tuttiCatch", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserTitle() {
        return I18n.t((String)"tutti.editCatchBatch.action.importMultiPost.sourceFile.title", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserButton() {
        return I18n.t((String)"tutti.editCatchBatch.action.importMultiPost.sourceFile.button", (Object[])new Object[0]);
    }

    @Override
    protected String getSuccessMessage(File file) {
        return I18n.t((String)"tutti.editCatchBatch.action.importMultiPost.success", (Object[])new Object[]{file});
    }

    @Override
    protected Map<String, Object> importBatches(MultiPostImportService multiPostImportExportService, File file, FishingOperation operation) {
        Map notImportedData = multiPostImportExportService.importCatchBatch(file, operation);
        return notImportedData;
    }

    @Override
    protected String buildNotImportedDataReportText(Map<String, Object> notImportedData) {
        WeightUnit catchWeightUnit = WeightUnit.KG;
        WeightUnit speciesWeightUnit = this.getConfig().getSpeciesWeightUnit();
        WeightUnit benthosWeightUnit = this.getConfig().getBenthosWeightUnit();
        WeightUnit marineLitterWeightUnit = this.getConfig().getMarineLitterWeightUnit();
        StringBuilder builder = new StringBuilder();
        Float catchTotalWeight = (Float)notImportedData.get("catchTotalWeight");
        this.addNotImportedWeightToReport(builder, catchTotalWeight, catchWeightUnit, I18n.n((String)"tutti.multiPostImportLog.catchTotalWeight", (Object[])new Object[0]));
        Float catchTotalRejectedWeight = (Float)notImportedData.get("catchTotalRejectedWeight");
        this.addNotImportedWeightToReport(builder, catchTotalRejectedWeight, catchWeightUnit, I18n.n((String)"tutti.multiPostImportLog.catchTotalRejectedWeight", (Object[])new Object[0]));
        Float speciesTotalSortedWeight = (Float)notImportedData.get("speciesTotalSortedWeight");
        this.addNotImportedWeightToReport(builder, speciesTotalSortedWeight, speciesWeightUnit, I18n.n((String)"tutti.multiPostImportLog.speciesTotalSortedWeight", (Object[])new Object[0]));
        Float benthosTotalSortedWeight = (Float)notImportedData.get("benthosTotalSortedWeight");
        this.addNotImportedWeightToReport(builder, benthosTotalSortedWeight, benthosWeightUnit, I18n.n((String)"tutti.multiPostImportLog.benthosTotalSortedWeight", (Object[])new Object[0]));
        Float marineLitterTotalWeight = (Float)notImportedData.get("marineLitterTotalWeight");
        this.addNotImportedWeightToReport(builder, marineLitterTotalWeight, marineLitterWeightUnit, I18n.n((String)"tutti.multiPostImportLog.marineLitterTotalWeight", (Object[])new Object[0]));
        return builder.toString();
    }

    @Override
    protected EditCatchesUI getEditCatchUI() {
        EditCatchesUI catchesUI = (EditCatchesUI)this.getUI();
        return catchesUI;
    }
}

