/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.UIManager;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.tab.CustomTab;
import org.nuiton.jaxx.application.swing.tab.TabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.util.beans.BeanMonitor;
import org.nuiton.util.beans.BeanUtil;

public class CatchCustomTab
extends CustomTab {
    private static final long serialVersionUID = 1L;
    private final Set<String> modifyPropertyNames;
    protected transient BeanMonitor monitor;
    protected final Font defaultFont;

    public static CatchCustomTab newCustomTab(TabContentModel model, TabContainerHandler handler, Set<String> modifyPropertyNames) {
        CatchCustomTab customTab = new CatchCustomTab(model, handler, modifyPropertyNames);
        customTab.init();
        return customTab;
    }

    protected void init() {
        this.monitor = new BeanMonitor(this.modifyPropertyNames.toArray(new String[this.modifyPropertyNames.size()]));
        this.monitor.setBean((Object)this.model);
        try {
            BeanUtil.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CatchCustomTab.this.onPropertyChanged(evt.getPropertyName(), evt.getNewValue());
                }
            }, (Object)this.model);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not init listener", (Throwable)e);
        }
    }

    void onPropertyChanged(String propertyName, Object value) {
        if (propertyName.equals("modify")) {
            Boolean newValue = (Boolean)value;
            if (newValue != null && !newValue.booleanValue()) {
                this.monitor.clearModified();
                this.updateTitle2(this.monitor.wasModified(), this.model.isEmpty());
            }
        } else if (this.modifyPropertyNames.contains(propertyName)) {
            this.updateTitle2(this.monitor.wasModified(), this.model.isEmpty());
        }
    }

    CatchCustomTab(TabContentModel model, TabContainerHandler handler, Set<String> modifyPropertyNames) {
        super(model, handler);
        this.modifyPropertyNames = modifyPropertyNames;
        this.defaultFont = UIManager.getDefaults().getFont("Label.font");
    }

    protected void updateTitle() {
    }

    protected void updateTitle2(boolean modelModify, boolean modelEmpty) {
        int style;
        String titleValue = I18n.t((String)this.model.getTitle(), (Object[])new Object[0]);
        if (modelModify) {
            style = 1;
            titleValue = titleValue + "*";
        } else {
            style = modelEmpty ? 2 : 0;
        }
        this.title.setText(titleValue);
        this.title.setFont(this.defaultFont.deriveFont(style));
    }
}

