/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.RowExecutor;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.executor.TableItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.w3c.dom.css.CSSValue;

public class TableBandExecutor
extends StyledItemExecutor {
    int currentRow;
    TableItemExecutor tableExecutor;

    protected TableBandExecutor(ExecutorManager manager) {
        super(manager, 12);
    }

    @Override
    public IContent execute() {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        ITableBandContent bandContent = this.report.createTableBandContent();
        this.setContent(bandContent);
        this.restoreResultSet();
        this.initializeContent(bandDesign, bandContent);
        this.startTOCEntry(bandContent);
        this.handlePageBreakInterval();
        this.currentRow = 0;
        this.context.getProgressMonitor().onProgress(7, this.tableExecutor.rowId);
        return this.content;
    }

    protected void handlePageBreakInterval() {
        if (this.tableExecutor.breakOnDetailBand) {
            CSSValue pageBreak;
            IStyle style;
            BandDesign band = (BandDesign)this.design;
            if (band.getBandType() == 0) {
                if (this.tableExecutor.softBreakBefore) {
                    style = this.content.getStyle();
                    if (style != null && ((pageBreak = style.getProperty(33)) == null || IStyle.AUTO_VALUE.equals(pageBreak))) {
                        style.setProperty(33, IStyle.SOFT_VALUE);
                    }
                    this.tableExecutor.softBreakBefore = false;
                    this.tableExecutor.addAfterBreak = true;
                    this.tableExecutor.pageRowCount = 0;
                }
                this.tableExecutor.next();
                if (this.tableExecutor.needSoftBreakAfter()) {
                    this.tableExecutor.softBreakBefore = true;
                }
            }
            if (band.getBandType() == 3 && this.tableExecutor.softBreakBefore) {
                style = this.content.getStyle();
                if (style != null && ((pageBreak = style.getProperty(33)) == null || IStyle.AUTO_VALUE.equals(pageBreak))) {
                    style.setProperty(33, IStyle.SOFT_VALUE);
                }
                this.tableExecutor.softBreakBefore = false;
                this.tableExecutor.addAfterBreak = false;
                this.tableExecutor.pageRowCount = 0;
            }
        }
    }

    @Override
    public void close() throws BirtException {
        this.finishTOCEntry();
        super.close();
    }

    @Override
    public boolean hasNextChild() {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        return this.currentRow < bandDesign.getRowCount();
    }

    @Override
    public IReportItemExecutor getNextChild() {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        if (this.currentRow < bandDesign.getRowCount()) {
            RowDesign rowDesign;
            ReportItemExecutor childExecutor;
            if ((childExecutor = this.manager.createExecutor(this, rowDesign = bandDesign.getRow(this.currentRow++))) instanceof RowExecutor) {
                RowExecutor rowExecutor = (RowExecutor)childExecutor;
                rowExecutor.setRowId(this.tableExecutor.rowId++);
            } else {
                ++this.tableExecutor.rowId;
            }
            return childExecutor;
        }
        return null;
    }

    void setTableExecutor(TableItemExecutor tableExecutor) {
        this.tableExecutor = tableExecutor;
    }
}

