/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.multipost.AbstractFishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRow;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.AttachmentRow;
import fr.ifremer.tutti.service.catches.multipost.AttachmentRowModel;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRow;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchBatchRow;
import fr.ifremer.tutti.service.catches.multipost.CatchBatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRow;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchRow;
import fr.ifremer.tutti.service.catches.multipost.CatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchWeightsRow;
import fr.ifremer.tutti.service.catches.multipost.CatchWeightsRowModel;
import fr.ifremer.tutti.service.catches.multipost.FishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.FishingOperationRowModel;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRow;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRowModel;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRow;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRowModel;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterWeightRow;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterWeightRowModel;
import fr.ifremer.tutti.service.catches.multipost.MultiPostConstants;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class MultiPostExportService
extends AbstractTuttiService
implements MultiPostConstants {
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    public static final char CSV_SEPARATOR = ';';
    protected Map<String, CaracteristicQualitativeValue> sampleCategoryValueMap;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        SampleCategoryModel sampleCategoryModel = context.getSampleCategoryModel();
        this.sampleCategoryValueMap = Maps.newTreeMap();
        for (SampleCategoryModelEntry sampleCategoryModelEntry : sampleCategoryModel.getCategory()) {
            Caracteristic caracteristic = sampleCategoryModelEntry.getCaracteristic();
            if (caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) continue;
            List qualitativeValue = caracteristic.getQualitativeValue();
            for (CaracteristicQualitativeValue value : qualitativeValue) {
                this.sampleCategoryValueMap.put(value.getId(), value);
            }
        }
    }

    public void exportCatchBatch(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            CatchBatchRow weights = new CatchBatchRow();
            weights.setCatchTotalWeight(catchBatch.getCatchTotalWeight());
            weights.setCatchTotalRejectedWeight(catchBatch.getCatchTotalRejectedWeight());
            weights.setSpeciesTotalSortedWeight(catchBatch.getSpeciesTotalSortedWeight());
            weights.setBenthosTotalSortedWeight(catchBatch.getBenthosTotalSortedWeight());
            weights.setMarineLitterTotalWeight(catchBatch.getMarineLitterTotalWeight());
            ArrayList attachmentRows = Lists.newArrayList();
            this.addAttachments(catchBatch.getId(), catchBatch.getIdAsInt(), ObjectTypeCode.CATCH_BATCH, attachmentRows);
            this.exportOperation(weights, operation);
            this.exportCatchBatch(file, weights, attachmentRows);
        }
    }

    public void exportSpecies(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<SpeciesBatch> speciesBatchContainer = this.persistenceService.getRootSpeciesBatch(operationId, false);
            ArrayList rows = Lists.newArrayList();
            ArrayList frequencyRows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (SpeciesBatch batch : speciesBatchContainer.getChildren()) {
                this.createSpeciesRow(batch, null, rows, frequencyRows, attachmentRows);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            CatchWeightsRow weights = new CatchWeightsRow();
            weights.setTotalSortedWeight(catchBatch.getSpeciesTotalSortedWeight());
            weights.setInertWeight(catchBatch.getSpeciesTotalInertWeight());
            weights.setLivingNotItemizedWeight(catchBatch.getSpeciesTotalLivingNotItemizedWeight());
            this.exportOperation(weights, operation);
            this.exportCatches(file, "species.csv", weights, rows, frequencyRows, attachmentRows);
        }
    }

    public void exportBenthos(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<BenthosBatch> benthosBatchContainer = this.persistenceService.getRootBenthosBatch(operationId, false);
            ArrayList rows = Lists.newArrayList();
            ArrayList frequencyRows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (BenthosBatch batch : benthosBatchContainer.getChildren()) {
                this.createBenthosRow(batch, null, rows, frequencyRows, attachmentRows);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            CatchWeightsRow weights = new CatchWeightsRow();
            weights.setTotalSortedWeight(catchBatch.getBenthosTotalSortedWeight());
            weights.setInertWeight(catchBatch.getBenthosTotalInertWeight());
            weights.setLivingNotItemizedWeight(catchBatch.getBenthosTotalLivingNotItemizedWeight());
            this.exportOperation(weights, operation);
            this.exportCatches(file, "benthos.csv", weights, rows, frequencyRows, attachmentRows);
        }
    }

    public void exportMarineLitter(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<MarineLitterBatch> marineLitterBatchContainer = this.persistenceService.getRootMarineLitterBatch(operationId);
            ArrayList rows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (MarineLitterBatch batch : marineLitterBatchContainer.getChildren()) {
                MarineLitterRow row = new MarineLitterRow();
                String id = this.context.generateId(MarineLitterRow.class);
                row.setBatchId(id);
                row.setCategory(batch.getMarineLitterCategory());
                row.setSizeCategory(batch.getMarineLitterSizeCategory());
                row.setNumber(batch.getNumber());
                row.setWeight(batch.getWeight());
                row.setComment(batch.getComment());
                rows.add(row);
                this.addAttachments(id, batch.getIdAsInt(), ObjectTypeCode.BATCH, attachmentRows);
            }
            File directory = Files.createTempDir();
            ArrayList file2zip = Lists.newArrayList();
            MarineLitterRowModel marineLitterRowModel = new MarineLitterRowModel(';');
            File marineLitterFile = new File(directory, "marineLitter.csv");
            file2zip.add(marineLitterFile);
            this.export(marineLitterFile, (ExportModel)marineLitterRowModel, rows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            MarineLitterWeightRow weight = new MarineLitterWeightRow();
            weight.setTotalWeight(catchBatch.getMarineLitterTotalWeight());
            this.exportOperation(weight, operation);
            MarineLitterWeightRowModel weightModel = new MarineLitterWeightRowModel(';');
            File weightFile = new File(directory, "weights.csv");
            file2zip.add(weightFile);
            this.export(weightFile, (ExportModel)weightModel, Lists.newArrayList((Object[])new MarineLitterWeightRow[]{weight}), I18n.n((String)"tutti.service.multipost.export.weight.error", (Object[])new Object[0]));
            this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
        }
    }

    public void exportIndividualObservation(File file, FishingOperation operation) {
        List<IndividualObservationBatch> individualObservations = this.persistenceService.getAllIndividualObservationBatch(operation.getId());
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristicRows = Lists.newArrayList();
        ArrayList attachmentRows = Lists.newArrayList();
        for (IndividualObservationBatch batch : individualObservations) {
            IndividualObservationRow row = new IndividualObservationRow();
            String id = this.context.generateId(IndividualObservationRow.class);
            row.setBatchId(id);
            row.setSpecies(batch.getSpecies());
            row.setWeight(batch.getWeight());
            row.setSize(batch.getSize());
            row.setLengthStepCaracteristic(batch.getLengthStepCaracteristic());
            row.setComment(batch.getComment());
            rows.add(row);
            CaracteristicMap caracteristicMap = batch.getCaracteristics();
            for (Caracteristic caracteristic : caracteristicMap.keySet()) {
                CaracteristicRow caracteristicRow = new CaracteristicRow();
                caracteristicRow.setBatchId(id);
                caracteristicRow.setCaracteristic(caracteristic);
                caracteristicRow.setValue((Serializable)caracteristicMap.get((Object)caracteristic));
                caracteristicRows.add(caracteristicRow);
            }
            this.addAttachments(id, batch.getIdAsInt(), ObjectTypeCode.SAMPLE, attachmentRows);
        }
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        IndividualObservationRowModel csvModel = new IndividualObservationRowModel(';');
        File individualObservationFile = new File(directory, "individualObservation.csv");
        file2zip.add(individualObservationFile);
        this.export(individualObservationFile, (ExportModel)csvModel, rows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        CaracteristicRowModel caracteristicCsvModel = new CaracteristicRowModel(';');
        File caracteristicFile = new File(directory, "caracteristics.csv");
        file2zip.add(caracteristicFile);
        this.export(caracteristicFile, (ExportModel)caracteristicCsvModel, caracteristicRows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        FishingOperationRow foRow = new FishingOperationRow();
        this.exportOperation(foRow, operation);
        FishingOperationRowModel foRowModel = new FishingOperationRowModel(';');
        File weightFile = new File(directory, "weights.csv");
        file2zip.add(weightFile);
        this.export(weightFile, (ExportModel)foRowModel, Lists.newArrayList((Object[])new FishingOperationRow[]{foRow}), I18n.n((String)"tutti.service.multipost.export.operation.error", (Object[])new Object[0]));
        this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
    }

    public void exportAccidentalCatch(File file, FishingOperation operation) {
        List<AccidentalBatch> accidentalCatches = this.persistenceService.getAllAccidentalBatch(operation.getId());
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristicRows = Lists.newArrayList();
        ArrayList attachmentRows = Lists.newArrayList();
        for (AccidentalBatch batch : accidentalCatches) {
            AccidentalCatchRow row = new AccidentalCatchRow();
            String id = this.context.generateId(AccidentalCatchRow.class);
            row.setBatchId(id);
            row.setSpecies(batch.getSpecies());
            row.setGender(batch.getGender());
            row.setWeight(batch.getWeight());
            row.setSize(batch.getSize());
            row.setLengthStepCaracteristic(batch.getLengthStepCaracteristic());
            row.setDeadOrAlive(batch.getDeadOrAlive());
            row.setComment(batch.getComment());
            rows.add(row);
            CaracteristicMap caracteristicMap = batch.getCaracteristics();
            for (Caracteristic caracteristic : caracteristicMap.keySet()) {
                CaracteristicRow caracteristicRow = new CaracteristicRow();
                caracteristicRow.setBatchId(id);
                caracteristicRow.setCaracteristic(caracteristic);
                caracteristicRow.setValue((Serializable)caracteristicMap.get((Object)caracteristic));
                caracteristicRows.add(caracteristicRow);
            }
            this.addAttachments(id, batch.getIdAsInt(), ObjectTypeCode.SAMPLE, attachmentRows);
        }
        AccidentalCatchRowModel csvModel = new AccidentalCatchRowModel(';');
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        File accidentalCatchesFile = new File(directory, "accidentalCatches.csv");
        file2zip.add(accidentalCatchesFile);
        this.export(accidentalCatchesFile, (ExportModel)csvModel, rows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        CaracteristicRowModel caracteristicCsvModel = new CaracteristicRowModel(';');
        File caracteristicFile = new File(directory, "caracteristics.csv");
        file2zip.add(caracteristicFile);
        this.export(caracteristicFile, (ExportModel)caracteristicCsvModel, caracteristicRows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        FishingOperationRow foRow = new FishingOperationRow();
        this.exportOperation(foRow, operation);
        FishingOperationRowModel foRowModel = new FishingOperationRowModel(';');
        File weightFile = new File(directory, "weights.csv");
        file2zip.add(weightFile);
        this.export(weightFile, (ExportModel)foRowModel, Lists.newArrayList((Object[])new FishingOperationRow[]{foRow}), I18n.n((String)"tutti.service.multipost.export.operation.error", (Object[])new Object[0]));
        this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
    }

    protected void exportCatchBatch(File file, CatchBatchRow weights, List<AttachmentRow> attachmentRows) {
        CatchBatchRowModel csvModel = new CatchBatchRowModel(';');
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        File weightsFile = new File(directory, "catchBatch.csv");
        file2zip.add(weightsFile);
        this.export(weightsFile, (ExportModel)csvModel, Lists.newArrayList((Object[])new CatchBatchRow[]{weights}), I18n.n((String)"tutti.service.multipost.export.weights.error", (Object[])new Object[0]));
        this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
    }

    protected void exportCatches(File file, String batchFile, CatchWeightsRow weights, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRowModel csvModel = new CatchRowModel(';');
        CatchFrequencyRowModel csvFrequencyModel = new CatchFrequencyRowModel(';');
        CatchWeightsRowModel catchWeightsModel = new CatchWeightsRowModel(';');
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        File weightsFile = new File(directory, "weights.csv");
        file2zip.add(weightsFile);
        this.export(weightsFile, (ExportModel)catchWeightsModel, Lists.newArrayList((Object[])new CatchWeightsRow[]{weights}), I18n.n((String)"tutti.service.multipost.export.weights.error", (Object[])new Object[0]));
        File speciesFile = new File(directory, batchFile);
        file2zip.add(speciesFile);
        this.export(speciesFile, (ExportModel)csvModel, (List)rows, I18n.n((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[0]));
        File frequencyFile = new File(directory, "frequencies.csv");
        file2zip.add(frequencyFile);
        this.export(frequencyFile, (ExportModel)csvFrequencyModel, (List)frequencyRows, I18n.n((String)"tutti.service.multipost.export.frequencies.error", (Object[])new Object[0]));
        this.exportAttachmentsAndCreateZip(file, directory, file2zip, attachmentRows);
    }

    protected void createSpeciesRow(SpeciesBatch batch, String parentId, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRow row = new CatchRow();
        String id = this.context.generateId(CatchRow.class);
        row.setId(id);
        row.setParentId(parentId);
        row.setSpecies(batch.getSpecies());
        row.setCategoryId(batch.getSampleCategoryId());
        row.setCategoryValue(batch.getSampleCategoryValue());
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        rows.add(row);
        this.addFrequencies(id, batch.getId(), frequencyRows);
        this.addAttachments(id, batch.getIdAsInt(), ObjectTypeCode.BATCH, attachmentRows);
        for (SpeciesBatch child : batch.getChildBatchs()) {
            this.createSpeciesRow(child, id, rows, frequencyRows, attachmentRows);
        }
    }

    protected void createBenthosRow(BenthosBatch batch, String parentId, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRow row = new CatchRow();
        String id = this.context.generateId(CatchRow.class);
        row.setId(id);
        row.setParentId(parentId);
        row.setSpecies(batch.getSpecies());
        row.setCategoryId(batch.getSampleCategoryId());
        row.setCategoryValue(batch.getSampleCategoryValue());
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        rows.add(row);
        this.addFrequencies(id, batch.getId(), frequencyRows);
        this.addAttachments(id, batch.getIdAsInt(), ObjectTypeCode.BATCH, attachmentRows);
        for (BenthosBatch child : batch.getChildBatchs()) {
            this.createBenthosRow(child, id, rows, frequencyRows, attachmentRows);
        }
    }

    protected void exportOperation(AbstractFishingOperationRow afoRow, FishingOperation operation) {
        afoRow.setStationNumber(operation.getStationNumber());
        afoRow.setOperationNumber(operation.getFishingOperationNumber());
        afoRow.setMultirigAggregation(operation.getMultirigAggregation());
        afoRow.setDate(operation.getGearShootingStartDate());
    }

    protected void addFrequencies(String rowId, String batchId, List<CatchFrequencyRow> frequencyRows) {
        List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batchId);
        for (SpeciesBatchFrequency frequency : frequencies) {
            CatchFrequencyRow frequencyRow = new CatchFrequencyRow();
            frequencyRow.setBatchId(rowId);
            frequencyRow.setLengthStepCaracteristic(frequency.getLengthStepCaracteristic());
            frequencyRow.setLengthStep(frequency.getLengthStep());
            frequencyRow.setNumber(frequency.getNumber());
            frequencyRow.setWeight(frequency.getWeight());
            frequencyRows.add(frequencyRow);
        }
    }

    protected void addAttachments(String batchId, int objectId, ObjectTypeCode objectType, List<AttachmentRow> attachmentRows) {
        List<Attachment> attachments = this.persistenceService.getAllAttachments(objectType, objectId);
        for (Attachment attachment : attachments) {
            AttachmentRow attachmentRow = new AttachmentRow();
            attachmentRow.setBatchId(batchId);
            attachmentRow.setName(attachment.getName());
            attachmentRow.setComment(attachment.getComment());
            attachmentRow.setFile(this.persistenceService.getAttachmentFile(attachment.getId()));
            attachmentRows.add(attachmentRow);
        }
    }

    protected <R> void export(File file, ExportModel<R> exportModel, List<R> rows, String errorMessage) {
        Writer writer = ApplicationIOUtil.newWriter((File)file, (String)I18n.n((String)"tutti.service.multipost.export.file.writer.error", (Object[])new Object[0]));
        try {
            Export export = Export.newExport(exportModel, rows);
            export.write(writer);
            writer.close();
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)errorMessage, (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected void exportAttachments(File directory, List<File> file2zip, List<AttachmentRow> attachmentRows) {
        AttachmentRowModel csvAttachmentModel = new AttachmentRowModel(';');
        File attachmentDirectory = new File(directory, "attachments");
        ApplicationIOUtil.forceMkdir((File)attachmentDirectory, (String)I18n.t((String)"tutti.service.multipost.attachment.mkdir.error", (Object[])new Object[]{attachmentDirectory}));
        file2zip.add(attachmentDirectory);
        for (AttachmentRow attachmentRow : attachmentRows) {
            File attachmentFile = attachmentRow.getFile();
            File destFile = new File(attachmentDirectory, attachmentFile.getName());
            ApplicationIOUtil.copyFile((File)attachmentFile, (File)destFile, (String)I18n.t((String)"tutti.service.multipost.attachment.copy.error", (Object[])new Object[]{attachmentFile}));
            file2zip.add(destFile);
        }
        File attachmentFile = new File(directory, "attachments.csv");
        file2zip.add(attachmentFile);
        this.export(attachmentFile, (ExportModel)csvAttachmentModel, (List)attachmentRows, I18n.n((String)"tutti.service.multipost.export.attachments.error", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportAttachmentsAndCreateZip(File file, File directory, List<File> file2zip, List<AttachmentRow> attachmentRows) {
        this.exportAttachments(directory, file2zip, attachmentRows);
        try {
            ApplicationIOUtil.zip((File)directory, (File)file, file2zip, (String)I18n.n((String)"tutti.service.multipost.export.error", (Object[])new Object[0]));
        }
        catch (Throwable throwable) {
            ApplicationIOUtil.deleteDirectory((File)directory, (String)I18n.t((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
            throw throwable;
        }
        ApplicationIOUtil.deleteDirectory((File)directory, (String)I18n.t((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
    }
}

