package fr.ifremer.tutti.ui.swing.content.operation.catches.actions;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.catches.multipost.MultiPostExportService;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

import javax.swing.JOptionPane;
import java.io.File;

import static org.nuiton.i18n.I18n.t;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public abstract class ExportMultiPostActionSupport<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
        extends LongActionSupport<M, UI, H> {

    /**
     * Do save the catches before export.
     */
    private Boolean doSaveCatches;

    /**
     * File to export.
     */
    private File file;

    /**
     * Fishing operation to export.
     */
    private FishingOperation fishingOperation;

    protected abstract String getFileExtension();

    protected abstract String getFileExtensionDescription();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserButton();

    protected abstract String getSuccessMessage(File file);

    protected abstract void doExport(MultiPostExportService multiPostImportExportService, File file, FishingOperation fishingOperation);

    public ExportMultiPostActionSupport(H handler) {
        super(handler, false);
    }

    protected EditCatchesUI getEditCatchUI() {
        EditCatchesUI catchesUI = getUI().getParentContainer(EditCatchesUI.class);
        return catchesUI;
    }

    @Override
    public final boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            doSaveCatches = false;

            EditCatchesUI catchesUI = getEditCatchUI();
            EditCatchesUIModel model = catchesUI.getModel();

            fishingOperation = model.getFishingOperation();

            boolean canSave = model.isModify() && model.isValid();

            // ask user to save before export (otherwise some data won't be exported)

            if (canSave) {

                String htmlMessage = String.format(
                        AbstractApplicationUIHandler.CONFIRMATION_FORMAT,
                        t("tutti.askToSaveCatch.message"),
                        t("tutti.askToSaveCatchBeforeExport.help"));

                int saveResponse = JOptionPane.showOptionDialog(getHandler().getTopestUI(),
                                                                htmlMessage,
                                                                t("tutti.askToSaveCatch.title"),
                                                                JOptionPane.OK_CANCEL_OPTION,
                                                                JOptionPane.QUESTION_MESSAGE,
                                                                null,
                                                                new String[]{t("tutti.option.saveCatch"), t("tutti.option.notSaveCatch"), t("tutti.option.cancelExport")},
                                                                t("tutti.option.saveCatch"));

                switch (saveResponse) {
                    case 0:

                        // should save
                        doSaveCatches = true;
                        break;
                    case 1:

                        // nothing to do before export
                        break;
                    case 2:

                        // cancel import
                        doAction = false;
                }

            }

            if (doAction) {

                String extension = getFileExtension();

                // choose file to export
                file = saveFile(decorate(fishingOperation, DecoratorService.FILE_NAME_COMPATIBLE),
                                extension,
                                getFileChooserTitle(),
                                getFileChooserButton(),
                                "^.*\\." + extension,
                                getFileExtensionDescription());

                doAction = file != null;

            }

        }

        return doAction;

    }

    @Override
    public final void doAction() throws Exception {

        if (doSaveCatches) {

            setProgressionModel(new ProgressionModel());
            ProgressionModel progressionModel = getProgressionModel();
            progressionModel.setTotal(2);

            progressionModel.increments("Sauvegarde de la capture");

            // save catches before export

            EditCatchesUI catchesUI = getEditCatchUI();
            getActionEngine().runInternalAction(catchesUI.getHandler(), SaveCatchBatchAction.class);

            progressionModel.increments("Lancement de l'export");

        }

        // do the export

        MultiPostExportService multiPostImportExportService = getContext().getMultiPostExportService();

        doExport(multiPostImportExportService, file, fishingOperation);

    }

    @Override
    public final void releaseAction() {
        file = null;
        fishingOperation = null;
        doSaveCatches = null;
        super.releaseAction();
    }

    @Override
    public final void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(getSuccessMessage(file));
    }

}
