/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.Batchs;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.Measurement;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="batchTreeHelper")
public class BatchTreeHelper
extends AbstractPersistenceService {
    public static final Integer SORTING_TYPE_ID = PmfmId.SCIENTIFIC_CRUISE_SORTING_TYPE.getValue();
    public static final Integer SORTING_TYPE2_ID = PmfmId.SCIENTIFIC_CRUISE_SORTING_TYPE2.getValue();
    private static final Log log = LogFactory.getLog(BatchTreeHelper.class);
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    protected Comparator<Batch> batchComparator = Batchs.newRankOrderComparator();

    public SortingBatch getSpeciesVracAliveItemizedRootBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Species > Alive Itemized", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue(), SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_SPECIES.getValue(), SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue());
    }

    public SortingBatch getBenthosVracAliveItemizedRootBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Benthos > Alive itemized", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue(), SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_BENTHOS.getValue(), SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue());
    }

    public SortingBatch getSpeciesHorsVracRootBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > Species", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue(), SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_SPECIES.getValue());
    }

    public SortingBatch getBenthosHorsVracRootBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > Benthos", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue(), SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_BENTHOS.getValue());
    }

    public SortingBatch getMarineLitterRootBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > Marine Litter", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue(), SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_MARINE_LITTER.getValue());
    }

    public SortingBatch getVracBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue());
    }

    public SortingBatch getHorsVracBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue());
    }

    public SortingBatch getRejectedBatch(CatchBatch batch) {
        return this.getSortingBatch((Batch)batch, "Unsorted", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.UNSORTED.getValue());
    }

    public SortingBatch getSpeciesVracRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Species", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_SPECIES.getValue());
    }

    public SortingBatch getBenthosVracRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Benthos", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_BENTHOS.getValue());
    }

    public SortingBatch getSpeciesVracAliveNotItemizedRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Species > Alive not itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_NOT_ITEMIZED.getValue());
    }

    public SortingBatch getBenthosVracAliveNotItemizedRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Benthos > Alive not itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_NOT_ITEMIZED.getValue());
    }

    public SortingBatch getSpeciesVracInertRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Species > Inert (not alive)", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_INERT.getValue());
    }

    public SortingBatch getBenthosVracInertRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Benthos > Inert (not alive)", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_INERT.getValue());
    }

    public SortingBatch getSpeciesVracAliveItemizedRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Species > Alive itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue());
    }

    public SortingBatch getBenthosVracAliveItemizedRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Vrac > Benthos > Alive itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue());
    }

    public SortingBatch getSpeciesHorsVracRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > Species", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_SPECIES.getValue());
    }

    public SortingBatch getBenthosHorsVracRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > Benthos", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_BENTHOS.getValue());
    }

    public SortingBatch getMarineLitterRootBatch(SortingBatch batch) {
        return this.getSortingBatch((Batch)batch, "Hors Vrac > MarineLitter", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_MARINE_LITTER.getValue());
    }

    public SortingBatch getOrCreateVracBatch(CatchBatch batch, Float weight, Float weightBeforeSampling) {
        return this.getOrCreate(batch, (Batch)batch, "Vrac", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue(), weight, weightBeforeSampling, (short)1);
    }

    public SortingBatch getOrCreateSpeciesVracRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > Species", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_SPECIES.getValue(), totalWeight, (short)1);
    }

    public SortingBatch getOrCreateSpeciesVracAliveNotItemizedRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > Species > Alive Not Itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_NOT_ITEMIZED.getValue(), totalWeight, (short)1);
    }

    public SortingBatch getOrCreateSpeciesVracInertRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > Species > Inert", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_INERT.getValue(), totalWeight, (short)2);
    }

    public SortingBatch getOrCreateSpeciesVracAliveItemizedRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > Benthos > Alive Itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue(), (short)3);
    }

    public SortingBatch getOrCreateBenthosVracRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > Benthos", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_BENTHOS.getValue(), totalWeight, (short)2);
    }

    public SortingBatch getOrCreateBenthosVracAliveNotItemizedRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > Benthos > Alive Not itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_NOT_ITEMIZED.getValue(), totalWeight, (short)1);
    }

    public SortingBatch getOrCreateBenthosVracInertRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > Benthos > Inert", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_INERT.getValue(), totalWeight, (short)2);
    }

    public SortingBatch getOrCreateBenthosVracAliveItemizedRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, "Vrac > Benthos > Alive Itemized", SORTING_TYPE2_ID, QualitativeValueId.SORTING_TYPE2_ALIVE_ITEMIZED.getValue(), (short)3);
    }

    public SortingBatch getOrCreateHorsVracBatch(CatchBatch batch) {
        return this.getOrCreate(batch, (Batch)batch, "Hors Vrac", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_HORS_VRAC.getValue(), (short)2);
    }

    public SortingBatch getOrCreateSpeciesHorsVracRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, "Hors Vrac > Species", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_SPECIES.getValue(), (short)1);
    }

    public SortingBatch getOrCreateBenthosHorsVracRootBatch(CatchBatch target, SortingBatch batch) {
        return this.getOrCreate(target, (Batch)batch, "Hors Vrac > Benthos", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_BENTHOS.getValue(), (short)2);
    }

    public SortingBatch getOrCreateMarineLitterRootBatch(CatchBatch target, SortingBatch batch, Float totalWeight) {
        return this.getOrCreate(target, (Batch)batch, "Hors Vrac > Marine Litter", SORTING_TYPE_ID, QualitativeValueId.SORTING_TYPE_MARINE_LITTER.getValue(), totalWeight, (short)3);
    }

    public SortingBatch getOrCreateRejectedBatch(CatchBatch batch, Float weight) {
        return this.getOrCreate(batch, (Batch)batch, "Unsorted", PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.UNSORTED.getValue(), weight, (short)3);
    }

    public void setWeightAndSampleRatio(SortingBatch target, Float weight, Float weightBeforeSampling) {
        this.catchBatchDao.setSortingBatchWeights(target, weight, weightBeforeSampling, PmfmId.WEIGHT_MEASURED.getValue(), this.measurementPersistenceHelper.getRecorderDepartmentId());
    }

    public void setSortingSamplingRatio(SortingBatch target, Float weight, Float weightBeforeSampling) {
        this.catchBatchDao.setSortingSamplingRatio(target, weight, weightBeforeSampling);
    }

    protected SortingBatch get(Batch parentBatch, Integer sortingPmfmId, Integer sortingQualitativeValueId) {
        SortingBatch result = this.getSortingBatch(parentBatch, null, sortingPmfmId, sortingQualitativeValueId);
        return result;
    }

    protected SortingBatch getSortingBatch(Batch source, String debugMessage, Integer ... ids) {
        return this.getSortingBatch(source.getChildBatchs(), debugMessage, ids);
    }

    protected SortingBatch getSortingBatch(Collection<Batch> childs, String debugMessage, Integer ... ids) {
        int nbParams = ids.length / 2;
        Object[] params = new Object[nbParams * 3];
        for (int i = 0; i < nbParams; ++i) {
            Integer sortingPmfmId = ids[2 * i];
            Integer sortingQualitativeValueId = ids[2 * i + 1];
            params[3 * i] = "pmfmId";
            params[3 * i + 1] = sortingPmfmId;
            params[3 * i + 2] = sortingQualitativeValueId;
        }
        SortingBatch result = this.catchBatchDao.getSortingBatch(childs, params);
        if (result != null && debugMessage != null && log.isDebugEnabled()) {
            log.debug((Object)("Loaded " + debugMessage + ": " + result.getId()));
        }
        return result;
    }

    protected SortingBatch getOrCreate(CatchBatch rootBatch, Batch batch, String debugMessage, Integer sortingPmfmId, Integer sortingQualitativeValueId, short rankOrder) {
        return this.getOrCreate(rootBatch, batch, debugMessage, sortingPmfmId, sortingQualitativeValueId, null, null, rankOrder);
    }

    protected SortingBatch getOrCreate(CatchBatch rootBatch, Batch batch, String debugMessage, Integer sortingPmfmId, Integer sortingQualitativeValueId, Float totalWeight, short rankOrder) {
        return this.getOrCreate(rootBatch, batch, debugMessage, sortingPmfmId, sortingQualitativeValueId, totalWeight, null, rankOrder);
    }

    protected SortingBatch getOrCreate(CatchBatch rootBatch, Batch batch, String debugMessage, Integer sortingPmfmId, Integer sortingQualitativeValueId, Float weight, Float weightBeforeSampling, short rankOrder) {
        SortingBatch result = this.getSortingBatch(batch, debugMessage, sortingPmfmId, sortingQualitativeValueId);
        if (result == null) {
            result = SortingBatch.Factory.newInstance();
            if (batch.getChildBatchs() == null) {
                batch.setChildBatchs((Collection)Sets.newHashSet());
            }
            batch.getChildBatchs().add(result);
            QualityFlagImpl qualityFlag = this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue()));
            result.setQualityFlag((QualityFlag)qualityFlag);
            result.setRootBatch(rootBatch);
            result.setParentBatch(batch);
            result.setExhaustiveInventory(Boolean.valueOf(true));
            result.setRankOrder(Short.valueOf(rankOrder));
            result.setReferenceTaxon(null);
            result.setTaxonGroup(null);
            Collection sortingMeasurements = result.getSortingMeasurements();
            HashSet notChangedSortingMeasurements = Sets.newHashSet();
            if (sortingMeasurements != null) {
                notChangedSortingMeasurements.addAll(sortingMeasurements);
            }
            if (sortingPmfmId != null && sortingQualitativeValueId != null) {
                SortingMeasurement sm = this.measurementPersistenceHelper.setSortingMeasurement(result, sortingPmfmId, sortingQualitativeValueId);
                notChangedSortingMeasurements.remove(sm);
            }
            if (sortingMeasurements != null) {
                sortingMeasurements.removeAll(notChangedSortingMeasurements);
            }
            this.catchBatchDao.createSortingBatch(result, rootBatch);
        }
        this.setWeightAndSampleRatio(result, weight, weightBeforeSampling);
        return result;
    }

    public void displayCatchBatch(CatchBatch result) {
        StringBuilder sb = new StringBuilder();
        this.displayBatch((Batch)result, 0, sb);
        log.info((Object)sb.toString());
    }

    protected void displayBatch(Batch batch, int level, StringBuilder sb) {
        QuantificationMeasurement quantificationMeasurement;
        BatchTreeToStringStyle style = new BatchTreeToStringStyle();
        ToStringBuilder builder = new ToStringBuilder((Object)batch, (ToStringStyle)style);
        builder.append("id", (Object)batch.getId());
        builder.append("rankOrder", (Object)batch.getRankOrder());
        if (batch instanceof CatchBatch) {
            CatchBatch catchBatch = (CatchBatch)batch;
            builder.append("synchronizationStatus", (Object)catchBatch.getSynchronizationStatus());
        }
        if (batch instanceof SortingBatch) {
            SortingBatch sortingBatch = (SortingBatch)batch;
            if (sortingBatch.getSamplingRatio() != null) {
                builder.append("samplingRatio", (Object)sortingBatch.getSamplingRatio());
            }
            if (sortingBatch.getSamplingRatioText() != null) {
                builder.append("samplingRatioText", (Object)sortingBatch.getSamplingRatioText());
            }
            if (sortingBatch.getIndividualCount() != null) {
                builder.append("individualCount", (Object)sortingBatch.getIndividualCount());
            }
            if (sortingBatch.getReferenceTaxon() != null) {
                ReferenceTaxon referenceTaxon = sortingBatch.getReferenceTaxon();
                builder.append("referenceTaxon", (Object)this.load(ReferenceTaxonImpl.class, referenceTaxon.getId()).getName());
            }
            SortingMeasurement sm = null;
            if (sortingBatch.getSortingMeasurements() != null && sortingBatch.getSortingMeasurements().size() == 1) {
                sm = (SortingMeasurement)sortingBatch.getSortingMeasurements().iterator().next();
            } else if (sortingBatch.getReferenceTaxon() != null && sortingBatch.getReferenceTaxon().getId() != null) {
                sm = this.measurementPersistenceHelper.getInheritedSortingMeasurement(sortingBatch);
            }
            if (sm != null) {
                String sortingMeasurementStr = this.measurementPersistenceHelper.toString((Measurement)sm);
                builder.append("sortingMeasurement", (Object)sortingMeasurementStr);
            }
        }
        if ((quantificationMeasurement = this.measurementPersistenceHelper.getWeightMeasurementQuantificationMeasurement(batch)) != null) {
            String quantificationMeasurementStr = this.measurementPersistenceHelper.toString((Measurement)quantificationMeasurement);
            builder.append("weightQuantificationMeasurement", (Object)quantificationMeasurementStr);
            builder.append("weightQuantificationMeasurement.isReferenceQuantification", (Object)quantificationMeasurement.getIsReferenceQuantification());
        }
        if (batch.getWeight() != null) {
            builder.append("weight", (Object)batch.getWeight());
        }
        if (batch.getWeightBeforeSampling() != null) {
            builder.append("weightBeforeSampling", (Object)batch.getWeightBeforeSampling());
        }
        builder.append("qualityFlag", (Object)this.load(QualityFlagImpl.class, (Serializable)((Object)batch.getQualityFlag().getCode())).getName());
        String prefix = "\n" + StringUtils.leftPad((String)"", (int)(2 * level));
        String batchStr = Joiner.on((String)prefix).join((Object[])builder.build().split("\n"));
        sb.append(prefix).append(batchStr);
        Collection childBatchs = batch.getChildBatchs();
        if (childBatchs != null) {
            ArrayList childBatchList = new ArrayList(childBatchs);
            Collections.sort(childBatchList, this.batchComparator);
            for (Batch childBatch : childBatchList) {
                this.displayBatch(childBatch, level + 1, sb);
            }
        }
    }

    public CatchBatch loadCatchBatch(Integer catchBatchId) {
        return this.catchBatchDao.loadFullTreeWithCache(catchBatchId, PmfmId.WEIGHT_MEASURED.getValue(), true, true);
    }

    static final class BatchTreeToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        BatchTreeToStringStyle() {
            this.setUseClassName(true);
            this.setUseShortClassName(true);
            this.setContentStart("");
            this.setFieldSeparator(SystemUtils.LINE_SEPARATOR + "  | ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd("");
        }
    }
}

